@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin

import com.pulumi.alicloud.hbr.RestoreJobArgs.builder
import com.pulumi.alicloud.hbr.kotlin.inputs.RestoreJobOtsDetailArgs
import com.pulumi.alicloud.hbr.kotlin.inputs.RestoreJobOtsDetailArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a Hybrid Backup Recovery (HBR) Restore Job resource.
 * For information about Hybrid Backup Recovery (HBR) Restore Job and how to use it, see [What is Restore Job](https://www.alibabacloud.com/help/doc-detail/186575.htm).
 * > **NOTE:** Available in v1.133.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const default = alicloud.hbr.getEcsBackupPlans({
 *     nameRegex: "plan-tf-used-dont-delete",
 * });
 * const defaultGetOssBackupPlans = alicloud.hbr.getOssBackupPlans({
 *     nameRegex: "plan-tf-used-dont-delete",
 * });
 * const defaultGetNasBackupPlans = alicloud.hbr.getNasBackupPlans({
 *     nameRegex: "plan-tf-used-dont-delete",
 * });
 * const ecsSnapshots = Promise.all([_default, _default])&#46;then(([_default, _default1]) => alicloud.hbr.getSnapshots({
 *     sourceType: "ECS_FILE",
 *     vaultId: _default.plans?.[0]?.vaultId,
 *     instanceId: _default1.plans?.[0]?.instanceId,
 * }));
 * const ossSnapshots = Promise.all([defaultGetOssBackupPlans, defaultGetOssBackupPlans])&#46;then(([defaultGetOssBackupPlans, defaultGetOssBackupPlans1]) => alicloud.hbr.getSnapshots({
 *     sourceType: "OSS",
 *     vaultId: defaultGetOssBackupPlans.plans?.[0]?.vaultId,
 *     bucket: defaultGetOssBackupPlans1.plans?.[0]?.bucket,
 * }));
 * const nasSnapshots = Promise.all([defaultGetNasBackupPlans, defaultGetNasBackupPlans, defaultGetNasBackupPlans])&#46;then(([defaultGetNasBackupPlans, defaultGetNasBackupPlans1, defaultGetNasBackupPlans2]) => alicloud.hbr.getSnapshots({
 *     sourceType: "NAS",
 *     vaultId: defaultGetNasBackupPlans.plans?.[0]?.vaultId,
 *     fileSystemId: defaultGetNasBackupPlans1.plans?.[0]?.fileSystemId,
 *     createTime: defaultGetNasBackupPlans2.plans?.[0]?.createTime,
 * }));
 * const nasJob = new alicloud.hbr.RestoreJob("nasJob", {
 *     snapshotHash: nasSnapshots.then(nasSnapshots => nasSnapshots.snapshots?.[0]?.snapshotHash),
 *     vaultId: defaultGetNasBackupPlans.then(defaultGetNasBackupPlans => defaultGetNasBackupPlans.plans?.[0]?.vaultId),
 *     sourceType: "NAS",
 *     restoreType: "NAS",
 *     snapshotId: nasSnapshots.then(nasSnapshots => nasSnapshots.snapshots?.[0]?.snapshotId),
 *     targetFileSystemId: defaultGetNasBackupPlans.then(defaultGetNasBackupPlans => defaultGetNasBackupPlans.plans?.[0]?.fileSystemId),
 *     targetCreateTime: defaultGetNasBackupPlans.then(defaultGetNasBackupPlans => defaultGetNasBackupPlans.plans?.[0]?.createTime),
 *     targetPath: "/",
 *     options: "    {\"includes\":[], \"excludes\":[]}\n",
 * });
 * const ossJob = new alicloud.hbr.RestoreJob("ossJob", {
 *     snapshotHash: ossSnapshots.then(ossSnapshots => ossSnapshots.snapshots?.[0]?.snapshotHash),
 *     vaultId: defaultGetOssBackupPlans.then(defaultGetOssBackupPlans => defaultGetOssBackupPlans.plans?.[0]?.vaultId),
 *     sourceType: "OSS",
 *     restoreType: "OSS",
 *     snapshotId: ossSnapshots.then(ossSnapshots => ossSnapshots.snapshots?.[0]?.snapshotId),
 *     targetBucket: defaultGetOssBackupPlans.then(defaultGetOssBackupPlans => defaultGetOssBackupPlans.plans?.[0]?.bucket),
 *     targetPrefix: "",
 *     options: "    {\"includes\":[], \"excludes\":[]}\n",
 * });
 * const ecsJob = new alicloud.hbr.RestoreJob("ecsJob", {
 *     snapshotHash: ecsSnapshots.then(ecsSnapshots => ecsSnapshots.snapshots?.[0]?.snapshotHash),
 *     vaultId: _default.then(_default => _default.plans?.[0]?.vaultId),
 *     sourceType: "ECS_FILE",
 *     restoreType: "ECS_FILE",
 *     snapshotId: ecsSnapshots.then(ecsSnapshots => ecsSnapshots.snapshots?.[0]?.snapshotId),
 *     targetInstanceId: _default.then(_default => _default.plans?.[0]?.instanceId),
 *     targetPath: "/",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * default = alicloud.hbr.get_ecs_backup_plans(name_regex="plan-tf-used-dont-delete")
 * default_get_oss_backup_plans = alicloud.hbr.get_oss_backup_plans(name_regex="plan-tf-used-dont-delete")
 * default_get_nas_backup_plans = alicloud.hbr.get_nas_backup_plans(name_regex="plan-tf-used-dont-delete")
 * ecs_snapshots = alicloud.hbr.get_snapshots(source_type="ECS_FILE",
 *     vault_id=default.plans[0].vault_id,
 *     instance_id=default.plans[0].instance_id)
 * oss_snapshots = alicloud.hbr.get_snapshots(source_type="OSS",
 *     vault_id=default_get_oss_backup_plans.plans[0].vault_id,
 *     bucket=default_get_oss_backup_plans.plans[0].bucket)
 * nas_snapshots = alicloud.hbr.get_snapshots(source_type="NAS",
 *     vault_id=default_get_nas_backup_plans.plans[0].vault_id,
 *     file_system_id=default_get_nas_backup_plans.plans[0].file_system_id,
 *     create_time=default_get_nas_backup_plans.plans[0].create_time)
 * nas_job = alicloud.hbr.RestoreJob("nasJob",
 *     snapshot_hash=nas_snapshots.snapshots[0].snapshot_hash,
 *     vault_id=default_get_nas_backup_plans.plans[0].vault_id,
 *     source_type="NAS",
 *     restore_type="NAS",
 *     snapshot_id=nas_snapshots.snapshots[0].snapshot_id,
 *     target_file_system_id=default_get_nas_backup_plans.plans[0].file_system_id,
 *     target_create_time=default_get_nas_backup_plans.plans[0].create_time,
 *     target_path="/",
 *     options="    {\"includes\":[], \"excludes\":[]}\n")
 * oss_job = alicloud.hbr.RestoreJob("ossJob",
 *     snapshot_hash=oss_snapshots.snapshots[0].snapshot_hash,
 *     vault_id=default_get_oss_backup_plans.plans[0].vault_id,
 *     source_type="OSS",
 *     restore_type="OSS",
 *     snapshot_id=oss_snapshots.snapshots[0].snapshot_id,
 *     target_bucket=default_get_oss_backup_plans.plans[0].bucket,
 *     target_prefix="",
 *     options="    {\"includes\":[], \"excludes\":[]}\n")
 * ecs_job = alicloud.hbr.RestoreJob("ecsJob",
 *     snapshot_hash=ecs_snapshots.snapshots[0].snapshot_hash,
 *     vault_id=default.plans[0].vault_id,
 *     source_type="ECS_FILE",
 *     restore_type="ECS_FILE",
 *     snapshot_id=ecs_snapshots.snapshots[0].snapshot_id,
 *     target_instance_id=default.plans[0].instance_id,
 *     target_path="/")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = AliCloud.Hbr.GetEcsBackupPlans.Invoke(new()
 *     {
 *         NameRegex = "plan-tf-used-dont-delete",
 *     });
 *     var defaultGetOssBackupPlans = AliCloud.Hbr.GetOssBackupPlans.Invoke(new()
 *     {
 *         NameRegex = "plan-tf-used-dont-delete",
 *     });
 *     var defaultGetNasBackupPlans = AliCloud.Hbr.GetNasBackupPlans.Invoke(new()
 *     {
 *         NameRegex = "plan-tf-used-dont-delete",
 *     });
 *     var ecsSnapshots = AliCloud.Hbr.GetSnapshots.Invoke(new()
 *     {
 *         SourceType = "ECS_FILE",
 *         VaultId = @default.Apply(getEcsBackupPlansResult => getEcsBackupPlansResult.Plans[0]?.VaultId),
 *         InstanceId = @default.Apply(getEcsBackupPlansResult => getEcsBackupPlansResult.Plans[0]?.InstanceId),
 *     });
 *     var ossSnapshots = AliCloud.Hbr.GetSnapshots.Invoke(new()
 *     {
 *         SourceType = "OSS",
 *         VaultId = defaultGetOssBackupPlans.Apply(getOssBackupPlansResult => getOssBackupPlansResult.Plans[0]?.VaultId),
 *         Bucket = defaultGetOssBackupPlans.Apply(getOssBackupPlansResult => getOssBackupPlansResult.Plans[0]?.Bucket),
 *     });
 *     var nasSnapshots = AliCloud.Hbr.GetSnapshots.Invoke(new()
 *     {
 *         SourceType = "NAS",
 *         VaultId = defaultGetNasBackupPlans.Apply(getNasBackupPlansResult => getNasBackupPlansResult.Plans[0]?.VaultId),
 *         FileSystemId = defaultGetNasBackupPlans.Apply(getNasBackupPlansResult => getNasBackupPlansResult.Plans[0]?.FileSystemId),
 *         CreateTime = defaultGetNasBackupPlans.Apply(getNasBackupPlansResult => getNasBackupPlansResult.Plans[0]?.CreateTime),
 *     });
 *     var nasJob = new AliCloud.Hbr.RestoreJob("nasJob", new()
 *     {
 *         SnapshotHash = nasSnapshots.Apply(getSnapshotsResult => getSnapshotsResult.Snapshots[0]?.SnapshotHash),
 *         VaultId = defaultGetNasBackupPlans.Apply(getNasBackupPlansResult => getNasBackupPlansResult.Plans[0]?.VaultId),
 *         SourceType = "NAS",
 *         RestoreType = "NAS",
 *         SnapshotId = nasSnapshots.Apply(getSnapshotsResult => getSnapshotsResult.Snapshots[0]?.SnapshotId),
 *         TargetFileSystemId = defaultGetNasBackupPlans.Apply(getNasBackupPlansResult => getNasBackupPlansResult.Plans[0]?.FileSystemId),
 *         TargetCreateTime = defaultGetNasBackupPlans.Apply(getNasBackupPlansResult => getNasBackupPlansResult.Plans[0]?.CreateTime),
 *         TargetPath = "/",
 *         Options = @"    {""includes"":[], ""excludes"":[]}
 * ",
 *     });
 *     var ossJob = new AliCloud.Hbr.RestoreJob("ossJob", new()
 *     {
 *         SnapshotHash = ossSnapshots.Apply(getSnapshotsResult => getSnapshotsResult.Snapshots[0]?.SnapshotHash),
 *         VaultId = defaultGetOssBackupPlans.Apply(getOssBackupPlansResult => getOssBackupPlansResult.Plans[0]?.VaultId),
 *         SourceType = "OSS",
 *         RestoreType = "OSS",
 *         SnapshotId = ossSnapshots.Apply(getSnapshotsResult => getSnapshotsResult.Snapshots[0]?.SnapshotId),
 *         TargetBucket = defaultGetOssBackupPlans.Apply(getOssBackupPlansResult => getOssBackupPlansResult.Plans[0]?.Bucket),
 *         TargetPrefix = "",
 *         Options = @"    {""includes"":[], ""excludes"":[]}
 * ",
 *     });
 *     var ecsJob = new AliCloud.Hbr.RestoreJob("ecsJob", new()
 *     {
 *         SnapshotHash = ecsSnapshots.Apply(getSnapshotsResult => getSnapshotsResult.Snapshots[0]?.SnapshotHash),
 *         VaultId = @default.Apply(@default => @default.Apply(getEcsBackupPlansResult => getEcsBackupPlansResult.Plans[0]?.VaultId)),
 *         SourceType = "ECS_FILE",
 *         RestoreType = "ECS_FILE",
 *         SnapshotId = ecsSnapshots.Apply(getSnapshotsResult => getSnapshotsResult.Snapshots[0]?.SnapshotId),
 *         TargetInstanceId = @default.Apply(@default => @default.Apply(getEcsBackupPlansResult => getEcsBackupPlansResult.Plans[0]?.InstanceId)),
 *         TargetPath = "/",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_default, err := hbr.GetEcsBackupPlans(ctx, &hbr.GetEcsBackupPlansArgs{
 * 			NameRegex: pulumi.StringRef("plan-tf-used-dont-delete"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetOssBackupPlans, err := hbr.GetOssBackupPlans(ctx, &hbr.GetOssBackupPlansArgs{
 * 			NameRegex: pulumi.StringRef("plan-tf-used-dont-delete"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGetNasBackupPlans, err := hbr.GetNasBackupPlans(ctx, &hbr.GetNasBackupPlansArgs{
 * 			NameRegex: pulumi.StringRef("plan-tf-used-dont-delete"),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		ecsSnapshots, err := hbr.GetSnapshots(ctx, &hbr.GetSnapshotsArgs{
 * 			SourceType: "ECS_FILE",
 * 			VaultId:    _default.Plans[0].VaultId,
 * 			InstanceId: pulumi.StringRef(_default.Plans[0].InstanceId),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		ossSnapshots, err := hbr.GetSnapshots(ctx, &hbr.GetSnapshotsArgs{
 * 			SourceType: "OSS",
 * 			VaultId:    defaultGetOssBackupPlans.Plans[0].VaultId,
 * 			Bucket:     pulumi.StringRef(defaultGetOssBackupPlans.Plans[0].Bucket),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		nasSnapshots, err := hbr.GetSnapshots(ctx, &hbr.GetSnapshotsArgs{
 * 			SourceType:   "NAS",
 * 			VaultId:      defaultGetNasBackupPlans.Plans[0].VaultId,
 * 			FileSystemId: pulumi.StringRef(defaultGetNasBackupPlans.Plans[0].FileSystemId),
 * 			CreateTime:   pulumi.StringRef(defaultGetNasBackupPlans.Plans[0].CreateTime),
 * 		}, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbr.NewRestoreJob(ctx, "nasJob", &hbr.RestoreJobArgs{
 * 			SnapshotHash:       pulumi.String(nasSnapshots.Snapshots[0].SnapshotHash),
 * 			VaultId:            pulumi.String(defaultGetNasBackupPlans.Plans[0].VaultId),
 * 			SourceType:         pulumi.String("NAS"),
 * 			RestoreType:        pulumi.String("NAS"),
 * 			SnapshotId:         pulumi.String(nasSnapshots.Snapshots[0].SnapshotId),
 * 			TargetFileSystemId: pulumi.String(defaultGetNasBackupPlans.Plans[0].FileSystemId),
 * 			TargetCreateTime:   pulumi.String(defaultGetNasBackupPlans.Plans[0].CreateTime),
 * 			TargetPath:         pulumi.String("/"),
 * 			Options:            pulumi.String("    {\"includes\":[], \"excludes\":[]}\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbr.NewRestoreJob(ctx, "ossJob", &hbr.RestoreJobArgs{
 * 			SnapshotHash: pulumi.String(ossSnapshots.Snapshots[0].SnapshotHash),
 * 			VaultId:      pulumi.String(defaultGetOssBackupPlans.Plans[0].VaultId),
 * 			SourceType:   pulumi.String("OSS"),
 * 			RestoreType:  pulumi.String("OSS"),
 * 			SnapshotId:   pulumi.String(ossSnapshots.Snapshots[0].SnapshotId),
 * 			TargetBucket: pulumi.String(defaultGetOssBackupPlans.Plans[0].Bucket),
 * 			TargetPrefix: pulumi.String(""),
 * 			Options:      pulumi.String("    {\"includes\":[], \"excludes\":[]}\n"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbr.NewRestoreJob(ctx, "ecsJob", &hbr.RestoreJobArgs{
 * 			SnapshotHash:     pulumi.String(ecsSnapshots.Snapshots[0].SnapshotHash),
 * 			VaultId:          pulumi.String(_default.Plans[0].VaultId),
 * 			SourceType:       pulumi.String("ECS_FILE"),
 * 			RestoreType:      pulumi.String("ECS_FILE"),
 * 			SnapshotId:       pulumi.String(ecsSnapshots.Snapshots[0].SnapshotId),
 * 			TargetInstanceId: pulumi.String(_default.Plans[0].InstanceId),
 * 			TargetPath:       pulumi.String("/"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.hbr.HbrFunctions;
 * import com.pulumi.alicloud.hbr.inputs.GetEcsBackupPlansArgs;
 * import com.pulumi.alicloud.hbr.inputs.GetOssBackupPlansArgs;
 * import com.pulumi.alicloud.hbr.inputs.GetNasBackupPlansArgs;
 * import com.pulumi.alicloud.hbr.inputs.GetSnapshotsArgs;
 * import com.pulumi.alicloud.hbr.RestoreJob;
 * import com.pulumi.alicloud.hbr.RestoreJobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var default = HbrFunctions.getEcsBackupPlans(GetEcsBackupPlansArgs.builder()
 *             .nameRegex("plan-tf-used-dont-delete")
 *             .build());
 *         final var defaultGetOssBackupPlans = HbrFunctions.getOssBackupPlans(GetOssBackupPlansArgs.builder()
 *             .nameRegex("plan-tf-used-dont-delete")
 *             .build());
 *         final var defaultGetNasBackupPlans = HbrFunctions.getNasBackupPlans(GetNasBackupPlansArgs.builder()
 *             .nameRegex("plan-tf-used-dont-delete")
 *             .build());
 *         final var ecsSnapshots = HbrFunctions.getSnapshots(GetSnapshotsArgs.builder()
 *             .sourceType("ECS_FILE")
 *             .vaultId(default_.plans()[0].vaultId())
 *             .instanceId(default_.plans()[0].instanceId())
 *             .build());
 *         final var ossSnapshots = HbrFunctions.getSnapshots(GetSnapshotsArgs.builder()
 *             .sourceType("OSS")
 *             .vaultId(defaultGetOssBackupPlans.applyValue(getOssBackupPlansResult -> getOssBackupPlansResult.plans()[0].vaultId()))
 *             .bucket(defaultGetOssBackupPlans.applyValue(getOssBackupPlansResult -> getOssBackupPlansResult.plans()[0].bucket()))
 *             .build());
 *         final var nasSnapshots = HbrFunctions.getSnapshots(GetSnapshotsArgs.builder()
 *             .sourceType("NAS")
 *             .vaultId(defaultGetNasBackupPlans.applyValue(getNasBackupPlansResult -> getNasBackupPlansResult.plans()[0].vaultId()))
 *             .fileSystemId(defaultGetNasBackupPlans.applyValue(getNasBackupPlansResult -> getNasBackupPlansResult.plans()[0].fileSystemId()))
 *             .createTime(defaultGetNasBackupPlans.applyValue(getNasBackupPlansResult -> getNasBackupPlansResult.plans()[0].createTime()))
 *             .build());
 *         var nasJob = new RestoreJob("nasJob", RestoreJobArgs.builder()
 *             .snapshotHash(nasSnapshots.applyValue(getSnapshotsResult -> getSnapshotsResult.snapshots()[0].snapshotHash()))
 *             .vaultId(defaultGetNasBackupPlans.applyValue(getNasBackupPlansResult -> getNasBackupPlansResult.plans()[0].vaultId()))
 *             .sourceType("NAS")
 *             .restoreType("NAS")
 *             .snapshotId(nasSnapshots.applyValue(getSnapshotsResult -> getSnapshotsResult.snapshots()[0].snapshotId()))
 *             .targetFileSystemId(defaultGetNasBackupPlans.applyValue(getNasBackupPlansResult -> getNasBackupPlansResult.plans()[0].fileSystemId()))
 *             .targetCreateTime(defaultGetNasBackupPlans.applyValue(getNasBackupPlansResult -> getNasBackupPlansResult.plans()[0].createTime()))
 *             .targetPath("/")
 *             .options("""
 *     {"includes":[], "excludes":[]}
 *             """)
 *             .build());
 *         var ossJob = new RestoreJob("ossJob", RestoreJobArgs.builder()
 *             .snapshotHash(ossSnapshots.applyValue(getSnapshotsResult -> getSnapshotsResult.snapshots()[0].snapshotHash()))
 *             .vaultId(defaultGetOssBackupPlans.applyValue(getOssBackupPlansResult -> getOssBackupPlansResult.plans()[0].vaultId()))
 *             .sourceType("OSS")
 *             .restoreType("OSS")
 *             .snapshotId(ossSnapshots.applyValue(getSnapshotsResult -> getSnapshotsResult.snapshots()[0].snapshotId()))
 *             .targetBucket(defaultGetOssBackupPlans.applyValue(getOssBackupPlansResult -> getOssBackupPlansResult.plans()[0].bucket()))
 *             .targetPrefix("")
 *             .options("""
 *     {"includes":[], "excludes":[]}
 *             """)
 *             .build());
 *         var ecsJob = new RestoreJob("ecsJob", RestoreJobArgs.builder()
 *             .snapshotHash(ecsSnapshots.applyValue(getSnapshotsResult -> getSnapshotsResult.snapshots()[0].snapshotHash()))
 *             .vaultId(default_.plans()[0].vaultId())
 *             .sourceType("ECS_FILE")
 *             .restoreType("ECS_FILE")
 *             .snapshotId(ecsSnapshots.applyValue(getSnapshotsResult -> getSnapshotsResult.snapshots()[0].snapshotId()))
 *             .targetInstanceId(default_.plans()[0].instanceId())
 *             .targetPath("/")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   nasJob:
 *     type: alicloud:hbr:RestoreJob
 *     properties:
 *       snapshotHash: ${nasSnapshots.snapshots[0].snapshotHash}
 *       vaultId: ${defaultGetNasBackupPlans.plans[0].vaultId}
 *       sourceType: NAS
 *       restoreType: NAS
 *       snapshotId: ${nasSnapshots.snapshots[0].snapshotId}
 *       targetFileSystemId: ${defaultGetNasBackupPlans.plans[0].fileSystemId}
 *       targetCreateTime: ${defaultGetNasBackupPlans.plans[0].createTime}
 *       targetPath: /
 *       options: |2
 *             {"includes":[], "excludes":[]}
 *   ossJob:
 *     type: alicloud:hbr:RestoreJob
 *     properties:
 *       snapshotHash: ${ossSnapshots.snapshots[0].snapshotHash}
 *       vaultId: ${defaultGetOssBackupPlans.plans[0].vaultId}
 *       sourceType: OSS
 *       restoreType: OSS
 *       snapshotId: ${ossSnapshots.snapshots[0].snapshotId}
 *       targetBucket: ${defaultGetOssBackupPlans.plans[0].bucket}
 *       targetPrefix:
 *       options: |2
 *             {"includes":[], "excludes":[]}
 *   ecsJob:
 *     type: alicloud:hbr:RestoreJob
 *     properties:
 *       snapshotHash: ${ecsSnapshots.snapshots[0].snapshotHash}
 *       vaultId: ${default.plans[0].vaultId}
 *       sourceType: ECS_FILE
 *       restoreType: ECS_FILE
 *       snapshotId: ${ecsSnapshots.snapshots[0].snapshotId}
 *       targetInstanceId: ${default.plans[0].instanceId}
 *       targetPath: /
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:hbr:getEcsBackupPlans
 *       Arguments:
 *         nameRegex: plan-tf-used-dont-delete
 *   defaultGetOssBackupPlans:
 *     fn::invoke:
 *       Function: alicloud:hbr:getOssBackupPlans
 *       Arguments:
 *         nameRegex: plan-tf-used-dont-delete
 *   defaultGetNasBackupPlans:
 *     fn::invoke:
 *       Function: alicloud:hbr:getNasBackupPlans
 *       Arguments:
 *         nameRegex: plan-tf-used-dont-delete
 *   ecsSnapshots:
 *     fn::invoke:
 *       Function: alicloud:hbr:getSnapshots
 *       Arguments:
 *         sourceType: ECS_FILE
 *         vaultId: ${default.plans[0].vaultId}
 *         instanceId: ${default.plans[0].instanceId}
 *   ossSnapshots:
 *     fn::invoke:
 *       Function: alicloud:hbr:getSnapshots
 *       Arguments:
 *         sourceType: OSS
 *         vaultId: ${defaultGetOssBackupPlans.plans[0].vaultId}
 *         bucket: ${defaultGetOssBackupPlans.plans[0].bucket}
 *   nasSnapshots:
 *     fn::invoke:
 *       Function: alicloud:hbr:getSnapshots
 *       Arguments:
 *         sourceType: NAS
 *         vaultId: ${defaultGetNasBackupPlans.plans[0].vaultId}
 *         fileSystemId: ${defaultGetNasBackupPlans.plans[0].fileSystemId}
 *         createTime: ${defaultGetNasBackupPlans.plans[0].createTime}
 * ```
 * <!--End PulumiCodeChooser -->
 * > **NOTE:** This resource can only be created, cannot be modified or deleted. Therefore, any modification of the resource attribute will not affect exist resource.
 * ## Import
 * Hybrid Backup Recovery (HBR) Restore Job can be imported using the id. Format to `<restore_job_id>:<restore_type>`, e.g.
 * ```sh
 * $ pulumi import alicloud:hbr/restoreJob:RestoreJob example your_restore_job_id:your_restore_type
 * ```
 * @property crossAccountRoleName The role name created in the original account RAM backup by the cross account managed by the current account.
 * @property crossAccountType The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
 * @property crossAccountUserId The original account ID of the cross account backup managed by the current account.
 * @property exclude The exclude path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/excludePath]`, up to 255 characters. **WARNING:** If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
 * @property include The include path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/includePath"]`, Up to 255 characters. **WARNING:** The field is required while source_type equals `OTS_TABLE` which means source table name. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
 * @property options Recovery options. **NOTE:** Required while source_type equals `OSS` or `NAS`, invalid while source_type equals `ECS_FILE`. It's a json string with format:`"{"includes":[],"excludes":[]}",`. Recovery options. When restores OTS_TABLE and real target time is the rangEnd time of the snapshot, it should be a string with format: `{"UI_TargetTime":1650032529018}`.
 * @property otsDetail The details about the Tablestore instance. See the following `Block ots_detail`.
 * @property restoreJobId Restore Job ID. It's the unique key of this resource, if you want to set this argument by yourself, you must specify a unique keyword that never appears.
 * @property restoreType The type of recovery destination. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS_ROLLBACK`. **Note**: Currently, there is a one-to-one correspondence between the data source type with the recovery destination type.
 * @property snapshotHash The hashcode of Snapshot.
 * @property snapshotId The ID of Snapshot.
 * @property sourceType The type of data source. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS`.
 * @property targetBucket The target name of OSS bucket. **NOTE:** Required while source_type equals `OSS`,
 * @property targetClientId The target client ID.
 * @property targetCreateTime The creation time of destination File System. **NOTE:** While source_type equals `NAS`, this parameter must be set. **Note:** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
 * @property targetDataSourceId The target data source ID.
 * @property targetFileSystemId The ID of destination File System. **NOTE:** Required while source_type equals `NAS`
 * @property targetInstanceId The target ID of ECS instance. **NOTE:** Required while source_type equals `ECS_FILE`
 * @property targetInstanceName The name of the Table store instance to which you want to restore data.**WARNING:** Required while source_type equals `OTS_TABLE`.
 * @property targetPath The target file path of (ECS) instance. **WARNING:** Required while source_type equals `NAS` or `ECS_FILE`, If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
 * @property targetPrefix The target prefix of the OSS object. **WARNING:** Required while source_type equals `OSS`. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
 * @property targetTableName The name of the table that stores the restored data. **WARNING:** Required while source_type equals `OTS_TABLE`.
 * @property targetTime The time when data is restored to the Table store instance. This value is a UNIX timestamp. Unit: seconds. **WARNING:** Required while source_type equals `OTS_TABLE`. **Note:** The time when data is restored to the Tablestore instance. It should be 0 if restores data at the End time of the snapshot.
 * @property udmDetail The full machine backup details.
 * @property vaultId The ID of backup vault.
 */
public data class RestoreJobArgs(
    public val crossAccountRoleName: Output<String>? = null,
    public val crossAccountType: Output<String>? = null,
    public val crossAccountUserId: Output<Int>? = null,
    public val exclude: Output<String>? = null,
    public val include: Output<String>? = null,
    public val options: Output<String>? = null,
    public val otsDetail: Output<RestoreJobOtsDetailArgs>? = null,
    public val restoreJobId: Output<String>? = null,
    public val restoreType: Output<String>? = null,
    public val snapshotHash: Output<String>? = null,
    public val snapshotId: Output<String>? = null,
    public val sourceType: Output<String>? = null,
    public val targetBucket: Output<String>? = null,
    public val targetClientId: Output<String>? = null,
    public val targetCreateTime: Output<String>? = null,
    public val targetDataSourceId: Output<String>? = null,
    public val targetFileSystemId: Output<String>? = null,
    public val targetInstanceId: Output<String>? = null,
    public val targetInstanceName: Output<String>? = null,
    public val targetPath: Output<String>? = null,
    public val targetPrefix: Output<String>? = null,
    public val targetTableName: Output<String>? = null,
    public val targetTime: Output<String>? = null,
    public val udmDetail: Output<String>? = null,
    public val vaultId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.RestoreJobArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.RestoreJobArgs =
        com.pulumi.alicloud.hbr.RestoreJobArgs.builder()
            .crossAccountRoleName(crossAccountRoleName?.applyValue({ args0 -> args0 }))
            .crossAccountType(crossAccountType?.applyValue({ args0 -> args0 }))
            .crossAccountUserId(crossAccountUserId?.applyValue({ args0 -> args0 }))
            .exclude(exclude?.applyValue({ args0 -> args0 }))
            .include(include?.applyValue({ args0 -> args0 }))
            .options(options?.applyValue({ args0 -> args0 }))
            .otsDetail(otsDetail?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .restoreJobId(restoreJobId?.applyValue({ args0 -> args0 }))
            .restoreType(restoreType?.applyValue({ args0 -> args0 }))
            .snapshotHash(snapshotHash?.applyValue({ args0 -> args0 }))
            .snapshotId(snapshotId?.applyValue({ args0 -> args0 }))
            .sourceType(sourceType?.applyValue({ args0 -> args0 }))
            .targetBucket(targetBucket?.applyValue({ args0 -> args0 }))
            .targetClientId(targetClientId?.applyValue({ args0 -> args0 }))
            .targetCreateTime(targetCreateTime?.applyValue({ args0 -> args0 }))
            .targetDataSourceId(targetDataSourceId?.applyValue({ args0 -> args0 }))
            .targetFileSystemId(targetFileSystemId?.applyValue({ args0 -> args0 }))
            .targetInstanceId(targetInstanceId?.applyValue({ args0 -> args0 }))
            .targetInstanceName(targetInstanceName?.applyValue({ args0 -> args0 }))
            .targetPath(targetPath?.applyValue({ args0 -> args0 }))
            .targetPrefix(targetPrefix?.applyValue({ args0 -> args0 }))
            .targetTableName(targetTableName?.applyValue({ args0 -> args0 }))
            .targetTime(targetTime?.applyValue({ args0 -> args0 }))
            .udmDetail(udmDetail?.applyValue({ args0 -> args0 }))
            .vaultId(vaultId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RestoreJobArgs].
 */
@PulumiTagMarker
public class RestoreJobArgsBuilder internal constructor() {
    private var crossAccountRoleName: Output<String>? = null

    private var crossAccountType: Output<String>? = null

    private var crossAccountUserId: Output<Int>? = null

    private var exclude: Output<String>? = null

    private var include: Output<String>? = null

    private var options: Output<String>? = null

    private var otsDetail: Output<RestoreJobOtsDetailArgs>? = null

    private var restoreJobId: Output<String>? = null

    private var restoreType: Output<String>? = null

    private var snapshotHash: Output<String>? = null

    private var snapshotId: Output<String>? = null

    private var sourceType: Output<String>? = null

    private var targetBucket: Output<String>? = null

    private var targetClientId: Output<String>? = null

    private var targetCreateTime: Output<String>? = null

    private var targetDataSourceId: Output<String>? = null

    private var targetFileSystemId: Output<String>? = null

    private var targetInstanceId: Output<String>? = null

    private var targetInstanceName: Output<String>? = null

    private var targetPath: Output<String>? = null

    private var targetPrefix: Output<String>? = null

    private var targetTableName: Output<String>? = null

    private var targetTime: Output<String>? = null

    private var udmDetail: Output<String>? = null

    private var vaultId: Output<String>? = null

    /**
     * @param value The role name created in the original account RAM backup by the cross account managed by the current account.
     */
    @JvmName("tadvyrrwxvuonejm")
    public suspend fun crossAccountRoleName(`value`: Output<String>) {
        this.crossAccountRoleName = value
    }

    /**
     * @param value The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
     */
    @JvmName("whixgyohtycpteqr")
    public suspend fun crossAccountType(`value`: Output<String>) {
        this.crossAccountType = value
    }

    /**
     * @param value The original account ID of the cross account backup managed by the current account.
     */
    @JvmName("fqphmwbxamvhpkrb")
    public suspend fun crossAccountUserId(`value`: Output<Int>) {
        this.crossAccountUserId = value
    }

    /**
     * @param value The exclude path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/excludePath]`, up to 255 characters. **WARNING:** If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
     */
    @JvmName("cloyfrhstikqevjd")
    public suspend fun exclude(`value`: Output<String>) {
        this.exclude = value
    }

    /**
     * @param value The include path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/includePath"]`, Up to 255 characters. **WARNING:** The field is required while source_type equals `OTS_TABLE` which means source table name. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
     */
    @JvmName("rioiteogkysbiytc")
    public suspend fun include(`value`: Output<String>) {
        this.include = value
    }

    /**
     * @param value Recovery options. **NOTE:** Required while source_type equals `OSS` or `NAS`, invalid while source_type equals `ECS_FILE`. It's a json string with format:`"{"includes":[],"excludes":[]}",`. Recovery options. When restores OTS_TABLE and real target time is the rangEnd time of the snapshot, it should be a string with format: `{"UI_TargetTime":1650032529018}`.
     */
    @JvmName("tyovndefanplgqqs")
    public suspend fun options(`value`: Output<String>) {
        this.options = value
    }

    /**
     * @param value The details about the Tablestore instance. See the following `Block ots_detail`.
     */
    @JvmName("kglqgxbeomccdjaf")
    public suspend fun otsDetail(`value`: Output<RestoreJobOtsDetailArgs>) {
        this.otsDetail = value
    }

    /**
     * @param value Restore Job ID. It's the unique key of this resource, if you want to set this argument by yourself, you must specify a unique keyword that never appears.
     */
    @JvmName("kppkdfgxaphaxuje")
    public suspend fun restoreJobId(`value`: Output<String>) {
        this.restoreJobId = value
    }

    /**
     * @param value The type of recovery destination. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS_ROLLBACK`. **Note**: Currently, there is a one-to-one correspondence between the data source type with the recovery destination type.
     */
    @JvmName("ebyryyqlulyxaild")
    public suspend fun restoreType(`value`: Output<String>) {
        this.restoreType = value
    }

    /**
     * @param value The hashcode of Snapshot.
     */
    @JvmName("bbhmuvteosylyrqs")
    public suspend fun snapshotHash(`value`: Output<String>) {
        this.snapshotHash = value
    }

    /**
     * @param value The ID of Snapshot.
     */
    @JvmName("pyqgehwhviefythi")
    public suspend fun snapshotId(`value`: Output<String>) {
        this.snapshotId = value
    }

    /**
     * @param value The type of data source. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS`.
     */
    @JvmName("bscpoudckucvkwly")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value The target name of OSS bucket. **NOTE:** Required while source_type equals `OSS`,
     */
    @JvmName("lfdscgaxefgkcqra")
    public suspend fun targetBucket(`value`: Output<String>) {
        this.targetBucket = value
    }

    /**
     * @param value The target client ID.
     */
    @JvmName("ecpqrldjoxdvflmt")
    public suspend fun targetClientId(`value`: Output<String>) {
        this.targetClientId = value
    }

    /**
     * @param value The creation time of destination File System. **NOTE:** While source_type equals `NAS`, this parameter must be set. **Note:** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
     */
    @JvmName("ougciaxjgabkkrin")
    public suspend fun targetCreateTime(`value`: Output<String>) {
        this.targetCreateTime = value
    }

    /**
     * @param value The target data source ID.
     */
    @JvmName("wdfendweanhiogkh")
    public suspend fun targetDataSourceId(`value`: Output<String>) {
        this.targetDataSourceId = value
    }

    /**
     * @param value The ID of destination File System. **NOTE:** Required while source_type equals `NAS`
     */
    @JvmName("rljvwhrxjwvoasea")
    public suspend fun targetFileSystemId(`value`: Output<String>) {
        this.targetFileSystemId = value
    }

    /**
     * @param value The target ID of ECS instance. **NOTE:** Required while source_type equals `ECS_FILE`
     */
    @JvmName("waeebyrgogilownx")
    public suspend fun targetInstanceId(`value`: Output<String>) {
        this.targetInstanceId = value
    }

    /**
     * @param value The name of the Table store instance to which you want to restore data.**WARNING:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("lyufufhomxmjxepw")
    public suspend fun targetInstanceName(`value`: Output<String>) {
        this.targetInstanceName = value
    }

    /**
     * @param value The target file path of (ECS) instance. **WARNING:** Required while source_type equals `NAS` or `ECS_FILE`, If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
     */
    @JvmName("gcsjtvdwgqvcqmen")
    public suspend fun targetPath(`value`: Output<String>) {
        this.targetPath = value
    }

    /**
     * @param value The target prefix of the OSS object. **WARNING:** Required while source_type equals `OSS`. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
     */
    @JvmName("nnyaladnsaieentj")
    public suspend fun targetPrefix(`value`: Output<String>) {
        this.targetPrefix = value
    }

    /**
     * @param value The name of the table that stores the restored data. **WARNING:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("vfdrtrdkgcsgqnir")
    public suspend fun targetTableName(`value`: Output<String>) {
        this.targetTableName = value
    }

    /**
     * @param value The time when data is restored to the Table store instance. This value is a UNIX timestamp. Unit: seconds. **WARNING:** Required while source_type equals `OTS_TABLE`. **Note:** The time when data is restored to the Tablestore instance. It should be 0 if restores data at the End time of the snapshot.
     */
    @JvmName("llkhbicbomtpeuvk")
    public suspend fun targetTime(`value`: Output<String>) {
        this.targetTime = value
    }

    /**
     * @param value The full machine backup details.
     */
    @JvmName("kmvilqgsotagoftn")
    public suspend fun udmDetail(`value`: Output<String>) {
        this.udmDetail = value
    }

    /**
     * @param value The ID of backup vault.
     */
    @JvmName("sbsnpklfhphuhwvr")
    public suspend fun vaultId(`value`: Output<String>) {
        this.vaultId = value
    }

    /**
     * @param value The role name created in the original account RAM backup by the cross account managed by the current account.
     */
    @JvmName("tncvxfbttyvbqhxq")
    public suspend fun crossAccountRoleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossAccountRoleName = mapped
    }

    /**
     * @param value The type of the cross account backup. Valid values: `SELF_ACCOUNT`, `CROSS_ACCOUNT`.
     */
    @JvmName("ntljwdrbgwtjhudf")
    public suspend fun crossAccountType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossAccountType = mapped
    }

    /**
     * @param value The original account ID of the cross account backup managed by the current account.
     */
    @JvmName("qylgollvjeygrvre")
    public suspend fun crossAccountUserId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crossAccountUserId = mapped
    }

    /**
     * @param value The exclude path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/excludePath]`, up to 255 characters. **WARNING:** If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
     */
    @JvmName("mbhxmfwwytwmcxxw")
    public suspend fun exclude(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclude = mapped
    }

    /**
     * @param value The include path. **NOTE:** Invalid while source_type equals `OSS` or `NAS`. It's a json string with format:`["/includePath"]`, Up to 255 characters. **WARNING:** The field is required while source_type equals `OTS_TABLE` which means source table name. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
     */
    @JvmName("jiojyvmikfslutjl")
    public suspend fun include(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.include = mapped
    }

    /**
     * @param value Recovery options. **NOTE:** Required while source_type equals `OSS` or `NAS`, invalid while source_type equals `ECS_FILE`. It's a json string with format:`"{"includes":[],"excludes":[]}",`. Recovery options. When restores OTS_TABLE and real target time is the rangEnd time of the snapshot, it should be a string with format: `{"UI_TargetTime":1650032529018}`.
     */
    @JvmName("ulablmrytpiqwsky")
    public suspend fun options(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param value The details about the Tablestore instance. See the following `Block ots_detail`.
     */
    @JvmName("nhqqmkplqkqjjpab")
    public suspend fun otsDetail(`value`: RestoreJobOtsDetailArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.otsDetail = mapped
    }

    /**
     * @param argument The details about the Tablestore instance. See the following `Block ots_detail`.
     */
    @JvmName("thbkpptfsngyhqin")
    public suspend fun otsDetail(argument: suspend RestoreJobOtsDetailArgsBuilder.() -> Unit) {
        val toBeMapped = RestoreJobOtsDetailArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.otsDetail = mapped
    }

    /**
     * @param value Restore Job ID. It's the unique key of this resource, if you want to set this argument by yourself, you must specify a unique keyword that never appears.
     */
    @JvmName("irsxjgmldmxbwhdf")
    public suspend fun restoreJobId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreJobId = mapped
    }

    /**
     * @param value The type of recovery destination. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS_ROLLBACK`. **Note**: Currently, there is a one-to-one correspondence between the data source type with the recovery destination type.
     */
    @JvmName("juuiuiynjakaelmn")
    public suspend fun restoreType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.restoreType = mapped
    }

    /**
     * @param value The hashcode of Snapshot.
     */
    @JvmName("qxamnllfkhoclagj")
    public suspend fun snapshotHash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotHash = mapped
    }

    /**
     * @param value The ID of Snapshot.
     */
    @JvmName("nhcohuwabnymriyh")
    public suspend fun snapshotId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotId = mapped
    }

    /**
     * @param value The type of data source. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`,`UDM_ECS`.
     */
    @JvmName("vpwglhlqjvgudyvj")
    public suspend fun sourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value The target name of OSS bucket. **NOTE:** Required while source_type equals `OSS`,
     */
    @JvmName("ssjtjdvybmehssak")
    public suspend fun targetBucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetBucket = mapped
    }

    /**
     * @param value The target client ID.
     */
    @JvmName("fgmvfuakwxbyufsx")
    public suspend fun targetClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetClientId = mapped
    }

    /**
     * @param value The creation time of destination File System. **NOTE:** While source_type equals `NAS`, this parameter must be set. **Note:** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
     */
    @JvmName("etogvdpinkqpnhpg")
    public suspend fun targetCreateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetCreateTime = mapped
    }

    /**
     * @param value The target data source ID.
     */
    @JvmName("acyvjpvfqebhxdhy")
    public suspend fun targetDataSourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetDataSourceId = mapped
    }

    /**
     * @param value The ID of destination File System. **NOTE:** Required while source_type equals `NAS`
     */
    @JvmName("qyyvsissxjgnsyvf")
    public suspend fun targetFileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetFileSystemId = mapped
    }

    /**
     * @param value The target ID of ECS instance. **NOTE:** Required while source_type equals `ECS_FILE`
     */
    @JvmName("pxeujmrqmvdfbibd")
    public suspend fun targetInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetInstanceId = mapped
    }

    /**
     * @param value The name of the Table store instance to which you want to restore data.**WARNING:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("ylwshqlgvhdxkvnn")
    public suspend fun targetInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetInstanceName = mapped
    }

    /**
     * @param value The target file path of (ECS) instance. **WARNING:** Required while source_type equals `NAS` or `ECS_FILE`, If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
     */
    @JvmName("ufpecygqqmeagore")
    public suspend fun targetPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPath = mapped
    }

    /**
     * @param value The target prefix of the OSS object. **WARNING:** Required while source_type equals `OSS`. If this value filled in incorrectly, the task may not start correctly, so please check the parameters before executing the plan.
     */
    @JvmName("ytbenfflqxhxovxg")
    public suspend fun targetPrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetPrefix = mapped
    }

    /**
     * @param value The name of the table that stores the restored data. **WARNING:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("xmnllqfugumixbvp")
    public suspend fun targetTableName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetTableName = mapped
    }

    /**
     * @param value The time when data is restored to the Table store instance. This value is a UNIX timestamp. Unit: seconds. **WARNING:** Required while source_type equals `OTS_TABLE`. **Note:** The time when data is restored to the Tablestore instance. It should be 0 if restores data at the End time of the snapshot.
     */
    @JvmName("elelokfjymclchyb")
    public suspend fun targetTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetTime = mapped
    }

    /**
     * @param value The full machine backup details.
     */
    @JvmName("scsfehuqfhhpbedq")
    public suspend fun udmDetail(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.udmDetail = mapped
    }

    /**
     * @param value The ID of backup vault.
     */
    @JvmName("sovirxrmymiihxvu")
    public suspend fun vaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultId = mapped
    }

    internal fun build(): RestoreJobArgs = RestoreJobArgs(
        crossAccountRoleName = crossAccountRoleName,
        crossAccountType = crossAccountType,
        crossAccountUserId = crossAccountUserId,
        exclude = exclude,
        include = include,
        options = options,
        otsDetail = otsDetail,
        restoreJobId = restoreJobId,
        restoreType = restoreType,
        snapshotHash = snapshotHash,
        snapshotId = snapshotId,
        sourceType = sourceType,
        targetBucket = targetBucket,
        targetClientId = targetClientId,
        targetCreateTime = targetCreateTime,
        targetDataSourceId = targetDataSourceId,
        targetFileSystemId = targetFileSystemId,
        targetInstanceId = targetInstanceId,
        targetInstanceName = targetInstanceName,
        targetPath = targetPath,
        targetPrefix = targetPrefix,
        targetTableName = targetTableName,
        targetTime = targetTime,
        udmDetail = udmDetail,
        vaultId = vaultId,
    )
}
