@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin

import com.pulumi.alicloud.hbr.VaultArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a HBR Backup vault resource.
 * For information about HBR Backup vault and how to use it, see [What is Backup vault](https://www.alibabacloud.com/help/en/hybrid-backup-recovery/latest/api-hbr-2017-09-08-createvault).
 * > **NOTE:** Available since v1.129.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * import * as random from "@pulumi/random";
 * const _default = new random.index.Integer("default", {
 *     min: 10000,
 *     max: 99999,
 * });
 * const example = new alicloud.hbr.Vault("example", {vaultName: `example_value_${_default.result}`});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * import pulumi_random as random
 * default = random.index.Integer("default",
 *     min=10000,
 *     max=99999)
 * example = alicloud.hbr.Vault("example", vault_name=f"example_value_{default['result']}")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * using Random = Pulumi.Random;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Random.Index.Integer("default", new()
 *     {
 *         Min = 10000,
 *         Max = 99999,
 *     });
 *     var example = new AliCloud.Hbr.Vault("example", new()
 *     {
 *         VaultName = $"example_value_{@default.Result}",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/hbr"
 * 	"github.com/pulumi/pulumi-random/sdk/v4/go/random"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := random.NewInteger(ctx, "default", &random.IntegerArgs{
 * 			Min: 10000,
 * 			Max: 99999,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = hbr.NewVault(ctx, "example", &hbr.VaultArgs{
 * 			VaultName: pulumi.Sprintf("example_value_%v", _default.Result),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.random.integer;
 * import com.pulumi.random.IntegerArgs;
 * import com.pulumi.alicloud.hbr.Vault;
 * import com.pulumi.alicloud.hbr.VaultArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new Integer("default", IntegerArgs.builder()
 *             .min(10000)
 *             .max(99999)
 *             .build());
 *         var example = new Vault("example", VaultArgs.builder()
 *             .vaultName(String.format("example_value_%s", default_.result()))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: random:integer
 *     properties:
 *       min: 10000
 *       max: 99999
 *   example:
 *     type: alicloud:hbr:Vault
 *     properties:
 *       vaultName: example_value_${default.result}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * HBR Vault can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:hbr/vault:Vault example <id>
 * ```
 * @property description The description of Vault. Defaults to an empty string.
 * @property encryptType Source Encryption Type，It is valid only when vault_type is `STANDARD` or `OTS_BACKUP`. Default value: `HBR_PRIVATE`. Valid values:
 * - `HBR_PRIVATE`: HBR is fully hosted, uses the backup service's own encryption method.
 * - `KMS`: Use Alibaba Cloud Kms to encryption.
 * @property kmsKeyId The key id or alias name of Alibaba Cloud Kms. It is required and valid only when encrypt_type is `KMS`.
 * @property vaultName The name of Vault.
 * @property vaultStorageClass The storage class of Vault. Valid values: `STANDARD`.
 * @property vaultType The type of Vault. Valid values: `STANDARD`, `OTS_BACKUP`.
 */
public data class VaultArgs(
    public val description: Output<String>? = null,
    public val encryptType: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val vaultName: Output<String>? = null,
    public val vaultStorageClass: Output<String>? = null,
    public val vaultType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.VaultArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.VaultArgs =
        com.pulumi.alicloud.hbr.VaultArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptType(encryptType?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .vaultName(vaultName?.applyValue({ args0 -> args0 }))
            .vaultStorageClass(vaultStorageClass?.applyValue({ args0 -> args0 }))
            .vaultType(vaultType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VaultArgs].
 */
@PulumiTagMarker
public class VaultArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var encryptType: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var vaultName: Output<String>? = null

    private var vaultStorageClass: Output<String>? = null

    private var vaultType: Output<String>? = null

    /**
     * @param value The description of Vault. Defaults to an empty string.
     */
    @JvmName("djlbycxydaojhwow")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Source Encryption Type，It is valid only when vault_type is `STANDARD` or `OTS_BACKUP`. Default value: `HBR_PRIVATE`. Valid values:
     * - `HBR_PRIVATE`: HBR is fully hosted, uses the backup service's own encryption method.
     * - `KMS`: Use Alibaba Cloud Kms to encryption.
     */
    @JvmName("numhxonrymarvqbp")
    public suspend fun encryptType(`value`: Output<String>) {
        this.encryptType = value
    }

    /**
     * @param value The key id or alias name of Alibaba Cloud Kms. It is required and valid only when encrypt_type is `KMS`.
     */
    @JvmName("nwaqfqkaitdgwbai")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The name of Vault.
     */
    @JvmName("halqnmnqspsbuagi")
    public suspend fun vaultName(`value`: Output<String>) {
        this.vaultName = value
    }

    /**
     * @param value The storage class of Vault. Valid values: `STANDARD`.
     */
    @JvmName("aplgqchpbabgmcgq")
    public suspend fun vaultStorageClass(`value`: Output<String>) {
        this.vaultStorageClass = value
    }

    /**
     * @param value The type of Vault. Valid values: `STANDARD`, `OTS_BACKUP`.
     */
    @JvmName("khrmndqajriemwau")
    public suspend fun vaultType(`value`: Output<String>) {
        this.vaultType = value
    }

    /**
     * @param value The description of Vault. Defaults to an empty string.
     */
    @JvmName("daxnvbsggpcpewmj")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Source Encryption Type，It is valid only when vault_type is `STANDARD` or `OTS_BACKUP`. Default value: `HBR_PRIVATE`. Valid values:
     * - `HBR_PRIVATE`: HBR is fully hosted, uses the backup service's own encryption method.
     * - `KMS`: Use Alibaba Cloud Kms to encryption.
     */
    @JvmName("vfcyuwryicpqrkot")
    public suspend fun encryptType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptType = mapped
    }

    /**
     * @param value The key id or alias name of Alibaba Cloud Kms. It is required and valid only when encrypt_type is `KMS`.
     */
    @JvmName("rbwiwidjihhltwit")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The name of Vault.
     */
    @JvmName("rslbiqnjvvskvjkg")
    public suspend fun vaultName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultName = mapped
    }

    /**
     * @param value The storage class of Vault. Valid values: `STANDARD`.
     */
    @JvmName("tjbqiabfqcyrvfve")
    public suspend fun vaultStorageClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultStorageClass = mapped
    }

    /**
     * @param value The type of Vault. Valid values: `STANDARD`, `OTS_BACKUP`.
     */
    @JvmName("wlvnjjaqutckjehs")
    public suspend fun vaultType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultType = mapped
    }

    internal fun build(): VaultArgs = VaultArgs(
        description = description,
        encryptType = encryptType,
        kmsKeyId = kmsKeyId,
        vaultName = vaultName,
        vaultStorageClass = vaultStorageClass,
        vaultType = vaultType,
    )
}
