@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.GetBackupJobsFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property key The key of the field to filter. Valid values: `PlanId`, `VaultId`, `InstanceId`, `Bucket`, `FileSystemId`, `CompleteTime`.
 * @property operator The operator of the field to filter. Valid values: `EQUAL`, `NOT_EQUAL`, `GREATER_THAN`, `GREATER_THAN_OR_EQUAL`, `LESS_THAN`, `LESS_THAN_OR_EQUAL`, `BETWEEN`, `IN`.
 * @property values Set of values that are accepted for the given field.
 * > **NOTE:** Numeric types such as `CompleteTime` do not support `IN` operations for the time being.
 */
public data class GetBackupJobsFilter(
    public val key: String? = null,
    public val `operator`: String? = null,
    public val values: List<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.GetBackupJobsFilter> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.GetBackupJobsFilter =
        com.pulumi.alicloud.hbr.inputs.GetBackupJobsFilter.builder()
            .key(key?.let({ args0 -> args0 }))
            .`operator`(`operator`?.let({ args0 -> args0 }))
            .values(values?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetBackupJobsFilter].
 */
@PulumiTagMarker
public class GetBackupJobsFilterBuilder internal constructor() {
    private var key: String? = null

    private var `operator`: String? = null

    private var values: List<String>? = null

    /**
     * @param value The key of the field to filter. Valid values: `PlanId`, `VaultId`, `InstanceId`, `Bucket`, `FileSystemId`, `CompleteTime`.
     */
    @JvmName("ktyihipwsvvcegiq")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.key = mapped
    }

    /**
     * @param value The operator of the field to filter. Valid values: `EQUAL`, `NOT_EQUAL`, `GREATER_THAN`, `GREATER_THAN_OR_EQUAL`, `LESS_THAN`, `LESS_THAN_OR_EQUAL`, `BETWEEN`, `IN`.
     */
    @JvmName("ngjsrifjthmrbrjt")
    public suspend fun `operator`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.`operator` = mapped
    }

    /**
     * @param value Set of values that are accepted for the given field.
     * > **NOTE:** Numeric types such as `CompleteTime` do not support `IN` operations for the time being.
     */
    @JvmName("llhoolbujeytalkl")
    public suspend fun values(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values Set of values that are accepted for the given field.
     * > **NOTE:** Numeric types such as `CompleteTime` do not support `IN` operations for the time being.
     */
    @JvmName("evjktfoklsyprqeq")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetBackupJobsFilter = GetBackupJobsFilter(
        key = key,
        `operator` = `operator`,
        values = values,
    )
}
