@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.GetBackupJobsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getBackupJobs.
 * @property filters
 * @property ids A list of Backup Job IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property sortDirection The sort direction, sort results by ascending or descending order based on the value jobs id. Valid values: `ASCEND`, `DESCEND`.
 * @property sourceType The type of data source. Valid values: `ECS_FILE`, `NAS`, `OSS`, `OTS`, `UDM_ECS`, `UDM_ECS_DISK`.
 * @property status The status of backup job. Valid values: `COMPLETE`, `PARTIAL_COMPLETE`, `FAILED`, `UNAVAILABLE`.
 */
public data class GetBackupJobsPlainArgs(
    public val filters: List<GetBackupJobsFilter>? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val sortDirection: String? = null,
    public val sourceType: String,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.GetBackupJobsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.GetBackupJobsPlainArgs =
        com.pulumi.alicloud.hbr.inputs.GetBackupJobsPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .sortDirection(sortDirection?.let({ args0 -> args0 }))
            .sourceType(sourceType.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBackupJobsPlainArgs].
 */
@PulumiTagMarker
public class GetBackupJobsPlainArgsBuilder internal constructor() {
    private var filters: List<GetBackupJobsFilter>? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var sortDirection: String? = null

    private var sourceType: String? = null

    private var status: String? = null

    /**
     * @param value
     */
    @JvmName("vrpncnaehsmuctnh")
    public suspend fun filters(`value`: List<GetBackupJobsFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("yaaemdfmwlmqedmt")
    public suspend fun filters(argument: List<suspend GetBackupJobsFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetBackupJobsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("hesptplcpkylcnsb")
    public suspend fun filters(vararg argument: suspend GetBackupJobsFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetBackupJobsFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xlgqikwbrgmsifmh")
    public suspend fun filters(argument: suspend GetBackupJobsFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetBackupJobsFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values
     */
    @JvmName("oxmfaqpslhxshnrh")
    public suspend fun filters(vararg values: GetBackupJobsFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value A list of Backup Job IDs.
     */
    @JvmName("cofxqecnakpjnura")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Backup Job IDs.
     */
    @JvmName("regvuwihoeuwdhdv")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("fdcxuiultaxijtda")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The sort direction, sort results by ascending or descending order based on the value jobs id. Valid values: `ASCEND`, `DESCEND`.
     */
    @JvmName("cgexxvujpmdbqimh")
    public suspend fun sortDirection(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sortDirection = mapped
    }

    /**
     * @param value The type of data source. Valid values: `ECS_FILE`, `NAS`, `OSS`, `OTS`, `UDM_ECS`, `UDM_ECS_DISK`.
     */
    @JvmName("wqwwmedulhyhphda")
    public suspend fun sourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sourceType = mapped
    }

    /**
     * @param value The status of backup job. Valid values: `COMPLETE`, `PARTIAL_COMPLETE`, `FAILED`, `UNAVAILABLE`.
     */
    @JvmName("mhkyhjxwqsucgxkm")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetBackupJobsPlainArgs = GetBackupJobsPlainArgs(
        filters = filters,
        ids = ids,
        outputFile = outputFile,
        sortDirection = sortDirection,
        sourceType = sourceType ?: throw PulumiNullFieldException("sourceType"),
        status = status,
    )
}
