@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.GetEcsBackupClientsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEcsBackupClients.
 * @property ids A list of Ecs Backup Client IDs.
 * @property instanceIds A list of ECS Instance IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid values: `ACTIVATED`, `DEACTIVATED`, `INSTALLING`, `INSTALL_FAILED`, `NOT_INSTALLED`, `REGISTERED`, `STOPPED`, `UNINSTALLING`, `UNINSTALL_FAILED`, `UNKNOWN`, `UPGRADE_FAILED`, `UPGRADING`.
 */
public data class GetEcsBackupClientsPlainArgs(
    public val ids: List<String>? = null,
    public val instanceIds: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.GetEcsBackupClientsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.GetEcsBackupClientsPlainArgs =
        com.pulumi.alicloud.hbr.inputs.GetEcsBackupClientsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceIds(instanceIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEcsBackupClientsPlainArgs].
 */
@PulumiTagMarker
public class GetEcsBackupClientsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceIds: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value A list of Ecs Backup Client IDs.
     */
    @JvmName("acgkmetxkljhidjw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Ecs Backup Client IDs.
     */
    @JvmName("yildbclejdcsxalw")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A list of ECS Instance IDs.
     */
    @JvmName("sadanghqldeyljgm")
    public suspend fun instanceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceIds = mapped
    }

    /**
     * @param values A list of ECS Instance IDs.
     */
    @JvmName("ktgtkxxwtarstuww")
    public suspend fun instanceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceIds = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("uwdlxdymyeysvbth")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `ACTIVATED`, `DEACTIVATED`, `INSTALLING`, `INSTALL_FAILED`, `NOT_INSTALLED`, `REGISTERED`, `STOPPED`, `UNINSTALLING`, `UNINSTALL_FAILED`, `UNKNOWN`, `UPGRADE_FAILED`, `UPGRADING`.
     */
    @JvmName("rxsoonwmvayqrqyg")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetEcsBackupClientsPlainArgs = GetEcsBackupClientsPlainArgs(
        ids = ids,
        instanceIds = instanceIds,
        outputFile = outputFile,
        status = status,
    )
}
