@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.GetEcsBackupPlansPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getEcsBackupPlans.
 * @property ids A list of EcsBackupPlan IDs.
 * @property instanceId The ECS instance ID of the EcsBackupPlan used.
 * @property nameRegex A regex string to filter results by EcsBackupPlan name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property vaultId The Vault ID of the EcsBackupPlan used.
 */
public data class GetEcsBackupPlansPlainArgs(
    public val ids: List<String>? = null,
    public val instanceId: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val vaultId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.GetEcsBackupPlansPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.GetEcsBackupPlansPlainArgs =
        com.pulumi.alicloud.hbr.inputs.GetEcsBackupPlansPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .vaultId(vaultId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEcsBackupPlansPlainArgs].
 */
@PulumiTagMarker
public class GetEcsBackupPlansPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var vaultId: String? = null

    /**
     * @param value A list of EcsBackupPlan IDs.
     */
    @JvmName("fnimxquuoxisagcw")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of EcsBackupPlan IDs.
     */
    @JvmName("mjanfxlcclmcjhbk")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ECS instance ID of the EcsBackupPlan used.
     */
    @JvmName("lufnpuhtdqoiqfmh")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value A regex string to filter results by EcsBackupPlan name.
     */
    @JvmName("knleuwyuvqddfssh")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ydbgnwqfjnqxwbsi")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The Vault ID of the EcsBackupPlan used.
     */
    @JvmName("syaxakdskdjlcvcr")
    public suspend fun vaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vaultId = mapped
    }

    internal fun build(): GetEcsBackupPlansPlainArgs = GetEcsBackupPlansPlainArgs(
        ids = ids,
        instanceId = instanceId,
        nameRegex = nameRegex,
        outputFile = outputFile,
        vaultId = vaultId,
    )
}
