@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.GetHanaBackupClientsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHanaBackupClients.
 * @property clientId The ID of the backup client.
 * @property clusterId The ID of the SAP HANA instance.
 * @property ids A list of Hana Backup Client IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property status The status of the Hana Backup Client. Valid Values: `REGISTERED`, `ACTIVATED`, `DEACTIVATED`, `INSTALLING`, `INSTALL_FAILED`, `NOT_INSTALLED`, `UPGRADING`, `UPGRADE_FAILED`, `UNINSTALLING`, `UNINSTALL_FAILED`, `STOPPED`, `UNKNOWN`.
 * @property vaultId The ID of the backup vault.
 */
public data class GetHanaBackupClientsPlainArgs(
    public val clientId: String? = null,
    public val clusterId: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
    public val vaultId: String,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.GetHanaBackupClientsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.GetHanaBackupClientsPlainArgs =
        com.pulumi.alicloud.hbr.inputs.GetHanaBackupClientsPlainArgs.builder()
            .clientId(clientId?.let({ args0 -> args0 }))
            .clusterId(clusterId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vaultId(vaultId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHanaBackupClientsPlainArgs].
 */
@PulumiTagMarker
public class GetHanaBackupClientsPlainArgsBuilder internal constructor() {
    private var clientId: String? = null

    private var clusterId: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var status: String? = null

    private var vaultId: String? = null

    /**
     * @param value The ID of the backup client.
     */
    @JvmName("rqxsrlkglkxxuaij")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.clientId = mapped
    }

    /**
     * @param value The ID of the SAP HANA instance.
     */
    @JvmName("yfhkvteujoikybkw")
    public suspend fun clusterId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.clusterId = mapped
    }

    /**
     * @param value A list of Hana Backup Client IDs.
     */
    @JvmName("bmdvpstahuwtrgll")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Hana Backup Client IDs.
     */
    @JvmName("mhxyxpbnvidfkxpj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("tfircwexygumoplv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("aiwdrukyvhwsmton")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("pnmjxhhxqxxspqil")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The status of the Hana Backup Client. Valid Values: `REGISTERED`, `ACTIVATED`, `DEACTIVATED`, `INSTALLING`, `INSTALL_FAILED`, `NOT_INSTALLED`, `UPGRADING`, `UPGRADE_FAILED`, `UNINSTALLING`, `UNINSTALL_FAILED`, `STOPPED`, `UNKNOWN`.
     */
    @JvmName("igglbrjmnmffhimt")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of the backup vault.
     */
    @JvmName("agiomufrxxcsoqus")
    public suspend fun vaultId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultId = mapped
    }

    internal fun build(): GetHanaBackupClientsPlainArgs = GetHanaBackupClientsPlainArgs(
        clientId = clientId,
        clusterId = clusterId,
        ids = ids,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        status = status,
        vaultId = vaultId ?: throw PulumiNullFieldException("vaultId"),
    )
}
