@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.GetHanaBackupPlansPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHanaBackupPlans.
 * @property clusterId
 * @property databaseName The name of the database.
 * @property ids A list of Hana Backup Plan IDs.
 * @property nameRegex A regex string to filter results by Hana Backup Plan name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property vaultId The id of the vault.
 */
public data class GetHanaBackupPlansPlainArgs(
    public val clusterId: String,
    public val databaseName: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val vaultId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.GetHanaBackupPlansPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.GetHanaBackupPlansPlainArgs =
        com.pulumi.alicloud.hbr.inputs.GetHanaBackupPlansPlainArgs.builder()
            .clusterId(clusterId.let({ args0 -> args0 }))
            .databaseName(databaseName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .vaultId(vaultId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHanaBackupPlansPlainArgs].
 */
@PulumiTagMarker
public class GetHanaBackupPlansPlainArgsBuilder internal constructor() {
    private var clusterId: String? = null

    private var databaseName: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var vaultId: String? = null

    /**
     * @param value
     */
    @JvmName("ecfhsbgsjmkvqgcf")
    public suspend fun clusterId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterId = mapped
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("mbntclmqykldxwll")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value A list of Hana Backup Plan IDs.
     */
    @JvmName("ewaaelfcshvfckds")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Hana Backup Plan IDs.
     */
    @JvmName("ounkoeftwdufntjy")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Hana Backup Plan name.
     */
    @JvmName("ajyeoolfhlxpakui")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qeidshxkbedbpfxt")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("ynhiwemstjcatiar")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("vybxfihqhqitoxfn")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The id of the vault.
     */
    @JvmName("wrioyjhggsqbcmua")
    public suspend fun vaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vaultId = mapped
    }

    internal fun build(): GetHanaBackupPlansPlainArgs = GetHanaBackupPlansPlainArgs(
        clusterId = clusterId ?: throw PulumiNullFieldException("clusterId"),
        databaseName = databaseName,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        vaultId = vaultId,
    )
}
