@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.GetHanaInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHanaInstances.
 * @property ids A list of Hana Instance IDs.
 * @property nameRegex A regex string to filter results by Hana Instance name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 * @property status The status of the SAP HANA instance. Valid values:
 * - `INITIALIZING`: The instance is being initialized.
 * - `INITIALIZED`: The instance is registered.
 * - `INVALID_HANA_NODE`: The instance is invalid.
 * - `INITIALIZE_FAILED`: The client fails to be installed on the instance.
 * @property vaultId The id of the vault.
 */
public data class GetHanaInstancesPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
    public val vaultId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.GetHanaInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.GetHanaInstancesPlainArgs =
        com.pulumi.alicloud.hbr.inputs.GetHanaInstancesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vaultId(vaultId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHanaInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetHanaInstancesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    private var status: String? = null

    private var vaultId: String? = null

    /**
     * @param value A list of Hana Instance IDs.
     */
    @JvmName("kqypgujqdoyqybtk")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Hana Instance IDs.
     */
    @JvmName("aicnexecpyxkvosr")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Hana Instance name.
     */
    @JvmName("mwmtemrscdyqlqly")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("woodxnraorcewbhg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("kdroasuucbwxfvna")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("ughfnechwdaiokgj")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    /**
     * @param value The status of the SAP HANA instance. Valid values:
     * - `INITIALIZING`: The instance is being initialized.
     * - `INITIALIZED`: The instance is registered.
     * - `INVALID_HANA_NODE`: The instance is invalid.
     * - `INITIALIZE_FAILED`: The client fails to be installed on the instance.
     */
    @JvmName("nabtwumkhcjjdvoc")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The id of the vault.
     */
    @JvmName("xinbnjmmpqgniacm")
    public suspend fun vaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vaultId = mapped
    }

    internal fun build(): GetHanaInstancesPlainArgs = GetHanaInstancesPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
        status = status,
        vaultId = vaultId,
    )
}
