@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.GetNasBackupPlansPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNasBackupPlans.
 * @property fileSystemId The Nas fileSystem instance ID of the EcsBackupPlan used.
 * @property ids A list of NasBackupPlan IDs.
 * @property nameRegex A regex string to filter results by NasBackupPlan name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property vaultId The backup vault ID of the NasBackupPlan used.
 */
public data class GetNasBackupPlansPlainArgs(
    public val fileSystemId: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val vaultId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.GetNasBackupPlansPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.GetNasBackupPlansPlainArgs =
        com.pulumi.alicloud.hbr.inputs.GetNasBackupPlansPlainArgs.builder()
            .fileSystemId(fileSystemId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .vaultId(vaultId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNasBackupPlansPlainArgs].
 */
@PulumiTagMarker
public class GetNasBackupPlansPlainArgsBuilder internal constructor() {
    private var fileSystemId: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var vaultId: String? = null

    /**
     * @param value The Nas fileSystem instance ID of the EcsBackupPlan used.
     */
    @JvmName("snfvrnkspueskumm")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.fileSystemId = mapped
    }

    /**
     * @param value A list of NasBackupPlan IDs.
     */
    @JvmName("tsjkndilbdaqidex")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of NasBackupPlan IDs.
     */
    @JvmName("yeoqlgehrsoeyuyn")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by NasBackupPlan name.
     */
    @JvmName("ohfxoohhtxvvxdgq")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rsbxwbmtvartqpco")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The backup vault ID of the NasBackupPlan used.
     */
    @JvmName("klwyldnemndmtjgt")
    public suspend fun vaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vaultId = mapped
    }

    internal fun build(): GetNasBackupPlansPlainArgs = GetNasBackupPlansPlainArgs(
        fileSystemId = fileSystemId,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        vaultId = vaultId,
    )
}
