@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.GetOssBackupPlansPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOssBackupPlans.
 * @property bucket The name of OSS bucket.
 * @property ids A list of OssBackupPlan IDs.
 * @property nameRegex A regex string to filter results by OssBackupPlan name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property vaultId The ID of backup vault the OssBackupPlan used.
 */
public data class GetOssBackupPlansPlainArgs(
    public val bucket: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val vaultId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.GetOssBackupPlansPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.GetOssBackupPlansPlainArgs =
        com.pulumi.alicloud.hbr.inputs.GetOssBackupPlansPlainArgs.builder()
            .bucket(bucket?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .vaultId(vaultId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOssBackupPlansPlainArgs].
 */
@PulumiTagMarker
public class GetOssBackupPlansPlainArgsBuilder internal constructor() {
    private var bucket: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var vaultId: String? = null

    /**
     * @param value The name of OSS bucket.
     */
    @JvmName("lnhlkfnpsrfutbjx")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.bucket = mapped
    }

    /**
     * @param value A list of OssBackupPlan IDs.
     */
    @JvmName("imjhnleyecebryqf")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of OssBackupPlan IDs.
     */
    @JvmName("hqwvjdjnygownaud")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by OssBackupPlan name.
     */
    @JvmName("qlforfagijliqqfj")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("fdlpiovtuvyerlkw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of backup vault the OssBackupPlan used.
     */
    @JvmName("qswrjxpygurwnygb")
    public suspend fun vaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vaultId = mapped
    }

    internal fun build(): GetOssBackupPlansPlainArgs = GetOssBackupPlansPlainArgs(
        bucket = bucket,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        vaultId = vaultId,
    )
}
