@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.GetOtsBackupPlansPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOtsBackupPlans.
 * @property ids A list of OtsBackupPlan IDs.
 * @property nameRegex A regex string to filter results by OtsBackupPlan name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property planId The ID of the backup plan.
 * @property planName The ID of the backup plan.
 * @property vaultId The ID of backup vault the OtsBackupPlan used.
 */
public data class GetOtsBackupPlansPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val planId: String? = null,
    public val planName: String? = null,
    public val vaultId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.GetOtsBackupPlansPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.GetOtsBackupPlansPlainArgs =
        com.pulumi.alicloud.hbr.inputs.GetOtsBackupPlansPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .planId(planId?.let({ args0 -> args0 }))
            .planName(planName?.let({ args0 -> args0 }))
            .vaultId(vaultId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOtsBackupPlansPlainArgs].
 */
@PulumiTagMarker
public class GetOtsBackupPlansPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var planId: String? = null

    private var planName: String? = null

    private var vaultId: String? = null

    /**
     * @param value A list of OtsBackupPlan IDs.
     */
    @JvmName("grkmerxdximbxhoo")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of OtsBackupPlan IDs.
     */
    @JvmName("lsvsejahjdnlhmlu")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by OtsBackupPlan name.
     */
    @JvmName("uojfwgerevislyjw")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qylofohcssfdacgw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the backup plan.
     */
    @JvmName("fxruwckxqpoxqsat")
    public suspend fun planId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.planId = mapped
    }

    /**
     * @param value The ID of the backup plan.
     */
    @JvmName("sewyljgcjvwfnwjr")
    public suspend fun planName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.planName = mapped
    }

    /**
     * @param value The ID of backup vault the OtsBackupPlan used.
     */
    @JvmName("mjbmjxfcqldrplry")
    public suspend fun vaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vaultId = mapped
    }

    internal fun build(): GetOtsBackupPlansPlainArgs = GetOtsBackupPlansPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        planId = planId,
        planName = planName,
        vaultId = vaultId,
    )
}
