@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.GetOtsSnapshotsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOtsSnapshots.
 * @property endTime The end time of the backup. This value must be a UNIX timestamp. Unit: milliseconds
 * @property ids
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property startTime The start time of the backup. This value must be a UNIX timestamp. Unit: milliseconds.
 */
public data class GetOtsSnapshotsPlainArgs(
    public val endTime: String? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val startTime: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.GetOtsSnapshotsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.GetOtsSnapshotsPlainArgs =
        com.pulumi.alicloud.hbr.inputs.GetOtsSnapshotsPlainArgs.builder()
            .endTime(endTime?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .startTime(startTime?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetOtsSnapshotsPlainArgs].
 */
@PulumiTagMarker
public class GetOtsSnapshotsPlainArgsBuilder internal constructor() {
    private var endTime: String? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var startTime: String? = null

    /**
     * @param value The end time of the backup. This value must be a UNIX timestamp. Unit: milliseconds
     */
    @JvmName("jojnkbnoojpxiwvs")
    public suspend fun endTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.endTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("ebukfwlucpbdhhqq")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values
     */
    @JvmName("fokvnniamynufxdp")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rnsurjpdjbrkyujc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The start time of the backup. This value must be a UNIX timestamp. Unit: milliseconds.
     */
    @JvmName("yxykriahipjjjahl")
    public suspend fun startTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.startTime = mapped
    }

    internal fun build(): GetOtsSnapshotsPlainArgs = GetOtsSnapshotsPlainArgs(
        endTime = endTime,
        ids = ids,
        outputFile = outputFile,
        startTime = startTime,
    )
}
