@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.GetReplicationVaultRegionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getReplicationVaultRegions.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetReplicationVaultRegionsPlainArgs(
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.GetReplicationVaultRegionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.GetReplicationVaultRegionsPlainArgs =
        com.pulumi.alicloud.hbr.inputs.GetReplicationVaultRegionsPlainArgs.builder()
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReplicationVaultRegionsPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationVaultRegionsPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("lipyxfruwechcgsx")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetReplicationVaultRegionsPlainArgs = GetReplicationVaultRegionsPlainArgs(
        outputFile = outputFile,
    )
}
