@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.GetRestoreJobsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRestoreJobs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property restoreIds The list of restore job IDs.
 * @property restoreType The Recovery Destination Types. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`, `UDM_ECS_ROLLBACK`.
 * @property sourceTypes The list of data source types. Valid values: `ECS_FILE`, `NAS`, `OSS`, `OTS_TABLE`,`UDM_ECS_ROLLBACK`.
 * @property status The status of restore job. Valid values: `CANCELED`, `CANCELING`, `COMPLETE`, `CREATED`, `EXPIRED`, `FAILED`, `PARTIAL_COMPLETE`, `QUEUED`, `RUNNING`.
 * @property targetBuckets The name of target OSS bucket.
 * @property targetFileSystemIds Valid while source_type equals `NAS`. The list of destination File System IDs.
 * @property targetInstanceIds The ID of target ECS instance.
 * @property vaultIds The list of backup vault IDs.
 */
public data class GetRestoreJobsPlainArgs(
    public val outputFile: String? = null,
    public val restoreIds: List<String>? = null,
    public val restoreType: String,
    public val sourceTypes: List<String>? = null,
    public val status: String? = null,
    public val targetBuckets: List<String>? = null,
    public val targetFileSystemIds: List<String>? = null,
    public val targetInstanceIds: List<String>? = null,
    public val vaultIds: List<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.GetRestoreJobsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.GetRestoreJobsPlainArgs =
        com.pulumi.alicloud.hbr.inputs.GetRestoreJobsPlainArgs.builder()
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .restoreIds(restoreIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .restoreType(restoreType.let({ args0 -> args0 }))
            .sourceTypes(sourceTypes?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .status(status?.let({ args0 -> args0 }))
            .targetBuckets(targetBuckets?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .targetFileSystemIds(targetFileSystemIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .targetInstanceIds(targetInstanceIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .vaultIds(vaultIds?.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetRestoreJobsPlainArgs].
 */
@PulumiTagMarker
public class GetRestoreJobsPlainArgsBuilder internal constructor() {
    private var outputFile: String? = null

    private var restoreIds: List<String>? = null

    private var restoreType: String? = null

    private var sourceTypes: List<String>? = null

    private var status: String? = null

    private var targetBuckets: List<String>? = null

    private var targetFileSystemIds: List<String>? = null

    private var targetInstanceIds: List<String>? = null

    private var vaultIds: List<String>? = null

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("afugqxuysnylwkvc")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The list of restore job IDs.
     */
    @JvmName("okaoyllbeipgosen")
    public suspend fun restoreIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.restoreIds = mapped
    }

    /**
     * @param values The list of restore job IDs.
     */
    @JvmName("avogpgktyrifwqcq")
    public suspend fun restoreIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.restoreIds = mapped
    }

    /**
     * @param value The Recovery Destination Types. Valid values: `ECS_FILE`, `NAS`, `OSS`,`OTS_TABLE`, `UDM_ECS_ROLLBACK`.
     */
    @JvmName("iucgoamaogiemfgi")
    public suspend fun restoreType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.restoreType = mapped
    }

    /**
     * @param value The list of data source types. Valid values: `ECS_FILE`, `NAS`, `OSS`, `OTS_TABLE`,`UDM_ECS_ROLLBACK`.
     */
    @JvmName("ejremleojmdrwmin")
    public suspend fun sourceTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.sourceTypes = mapped
    }

    /**
     * @param values The list of data source types. Valid values: `ECS_FILE`, `NAS`, `OSS`, `OTS_TABLE`,`UDM_ECS_ROLLBACK`.
     */
    @JvmName("wmojnaflbkssjxxa")
    public suspend fun sourceTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sourceTypes = mapped
    }

    /**
     * @param value The status of restore job. Valid values: `CANCELED`, `CANCELING`, `COMPLETE`, `CREATED`, `EXPIRED`, `FAILED`, `PARTIAL_COMPLETE`, `QUEUED`, `RUNNING`.
     */
    @JvmName("wkdytjiguxnbqoeg")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The name of target OSS bucket.
     */
    @JvmName("irfgphudondyqvvm")
    public suspend fun targetBuckets(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.targetBuckets = mapped
    }

    /**
     * @param values The name of target OSS bucket.
     */
    @JvmName("vhuoyvcyjrqcixtu")
    public suspend fun targetBuckets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.targetBuckets = mapped
    }

    /**
     * @param value Valid while source_type equals `NAS`. The list of destination File System IDs.
     */
    @JvmName("oqyftwlhhgjunhvp")
    public suspend fun targetFileSystemIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.targetFileSystemIds = mapped
    }

    /**
     * @param values Valid while source_type equals `NAS`. The list of destination File System IDs.
     */
    @JvmName("tyujremifybxvpxa")
    public suspend fun targetFileSystemIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.targetFileSystemIds = mapped
    }

    /**
     * @param value The ID of target ECS instance.
     */
    @JvmName("vjwdhhmxnexjwtlu")
    public suspend fun targetInstanceIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.targetInstanceIds = mapped
    }

    /**
     * @param values The ID of target ECS instance.
     */
    @JvmName("ciaapnunuqfcreut")
    public suspend fun targetInstanceIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.targetInstanceIds = mapped
    }

    /**
     * @param value The list of backup vault IDs.
     */
    @JvmName("ylvgpqmxevjxomgk")
    public suspend fun vaultIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vaultIds = mapped
    }

    /**
     * @param values The list of backup vault IDs.
     */
    @JvmName("rgflbmyxcesbmkwl")
    public suspend fun vaultIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultIds = mapped
    }

    internal fun build(): GetRestoreJobsPlainArgs = GetRestoreJobsPlainArgs(
        outputFile = outputFile,
        restoreIds = restoreIds,
        restoreType = restoreType ?: throw PulumiNullFieldException("restoreType"),
        sourceTypes = sourceTypes,
        status = status,
        targetBuckets = targetBuckets,
        targetFileSystemIds = targetFileSystemIds,
        targetInstanceIds = targetInstanceIds,
        vaultIds = vaultIds,
    )
}
