@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.GetServerBackupPlansPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getServerBackupPlans.
 * @property filters The filters.
 * @property ids A list of Server Backup Plan IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetServerBackupPlansPlainArgs(
    public val filters: List<GetServerBackupPlansFilter>? = null,
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.GetServerBackupPlansPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.GetServerBackupPlansPlainArgs =
        com.pulumi.alicloud.hbr.inputs.GetServerBackupPlansPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerBackupPlansPlainArgs].
 */
@PulumiTagMarker
public class GetServerBackupPlansPlainArgsBuilder internal constructor() {
    private var filters: List<GetServerBackupPlansFilter>? = null

    private var ids: List<String>? = null

    private var outputFile: String? = null

    /**
     * @param value The filters.
     */
    @JvmName("fpubhfkctbaxoyun")
    public suspend fun filters(`value`: List<GetServerBackupPlansFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument The filters.
     */
    @JvmName("hoerhatgibfeidel")
    public suspend fun filters(argument: List<suspend GetServerBackupPlansFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetServerBackupPlansFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument The filters.
     */
    @JvmName("pasucblgfakowhyw")
    public suspend fun filters(vararg argument: suspend GetServerBackupPlansFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetServerBackupPlansFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument The filters.
     */
    @JvmName("olvqemrwlrmvhams")
    public suspend fun filters(argument: suspend GetServerBackupPlansFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetServerBackupPlansFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values The filters.
     */
    @JvmName("buvnsmdxymostswe")
    public suspend fun filters(vararg values: GetServerBackupPlansFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value A list of Server Backup Plan IDs.
     */
    @JvmName("shxbbvtritrxndwo")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Server Backup Plan IDs.
     */
    @JvmName("xywwfnehbmbarlie")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("nsbcnxvyuekxwfev")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetServerBackupPlansPlainArgs = GetServerBackupPlansPlainArgs(
        filters = filters,
        ids = ids,
        outputFile = outputFile,
    )
}
