@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.GetSnapshotsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSnapshots.
 * @property bucket The bucket name of OSS. While source_type equals `OSS`, this parameter must be set.
 * @property completeTime Timestamp of Snapshot completion. Note The time format of the API adopts the ISO 8601 format, such as 2021-07-09T15:45:30CST or 2021-07-09T07:45:30Z. **Note**: While `complete_time_checker` equals `BETWEEN`, this field should be formatted such as `"2021-08-20T14:17:15CST,2021-08-26T14:17:15CST"`, The first part of this string is the start time, the second part is the end time, and the two parts should be separated by commas.
 * @property completeTimeChecker Complete time filter operator. Optional values: `MATCH_TERM`, `GREATER_THAN`, `GREATER_THAN_OR_EQUAL`, `LESS_THAN`, `LESS_THAN_OR_EQUAL`, `BETWEEN`.
 * @property createTime File system creation timestamp of Nas. While source_type equals `NAS`, this parameter must be set. **Note** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
 * @property fileSystemId The File System ID of Nas. While source_type equals `NAS`, this parameter must be set.
 * @property ids A list of Snapshot IDs.
 * @property instanceId The ID of ECS instance. The ecs backup client must have been installed on the host. While source_type equals `ECS_FILE`, this parameter must be set.
 * @property limit
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property query
 * @property sourceType Data source type, valid values: `ECS_FILE`, `OSS`, `NAS`.
 * @property status The status of snapshot, valid values: `COMPLETE`, `PARTIAL_COMPLETE`.
 * @property vaultId The ID of Vault.
 */
public data class GetSnapshotsPlainArgs(
    public val bucket: String? = null,
    public val completeTime: String? = null,
    public val completeTimeChecker: String? = null,
    public val createTime: String? = null,
    public val fileSystemId: String? = null,
    public val ids: List<String>? = null,
    public val instanceId: String? = null,
    public val limit: Int? = null,
    public val outputFile: String? = null,
    public val query: String? = null,
    public val sourceType: String,
    public val status: String? = null,
    public val vaultId: String,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.GetSnapshotsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.GetSnapshotsPlainArgs =
        com.pulumi.alicloud.hbr.inputs.GetSnapshotsPlainArgs.builder()
            .bucket(bucket?.let({ args0 -> args0 }))
            .completeTime(completeTime?.let({ args0 -> args0 }))
            .completeTimeChecker(completeTimeChecker?.let({ args0 -> args0 }))
            .createTime(createTime?.let({ args0 -> args0 }))
            .fileSystemId(fileSystemId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId?.let({ args0 -> args0 }))
            .limit(limit?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .query(query?.let({ args0 -> args0 }))
            .sourceType(sourceType.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vaultId(vaultId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSnapshotsPlainArgs].
 */
@PulumiTagMarker
public class GetSnapshotsPlainArgsBuilder internal constructor() {
    private var bucket: String? = null

    private var completeTime: String? = null

    private var completeTimeChecker: String? = null

    private var createTime: String? = null

    private var fileSystemId: String? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var limit: Int? = null

    private var outputFile: String? = null

    private var query: String? = null

    private var sourceType: String? = null

    private var status: String? = null

    private var vaultId: String? = null

    /**
     * @param value The bucket name of OSS. While source_type equals `OSS`, this parameter must be set.
     */
    @JvmName("ikwmnuglhdrogths")
    public suspend fun bucket(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.bucket = mapped
    }

    /**
     * @param value Timestamp of Snapshot completion. Note The time format of the API adopts the ISO 8601 format, such as 2021-07-09T15:45:30CST or 2021-07-09T07:45:30Z. **Note**: While `complete_time_checker` equals `BETWEEN`, this field should be formatted such as `"2021-08-20T14:17:15CST,2021-08-26T14:17:15CST"`, The first part of this string is the start time, the second part is the end time, and the two parts should be separated by commas.
     */
    @JvmName("enpgirmiotkpcllw")
    public suspend fun completeTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.completeTime = mapped
    }

    /**
     * @param value Complete time filter operator. Optional values: `MATCH_TERM`, `GREATER_THAN`, `GREATER_THAN_OR_EQUAL`, `LESS_THAN`, `LESS_THAN_OR_EQUAL`, `BETWEEN`.
     */
    @JvmName("ipdqawlbkpunoxln")
    public suspend fun completeTimeChecker(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.completeTimeChecker = mapped
    }

    /**
     * @param value File system creation timestamp of Nas. While source_type equals `NAS`, this parameter must be set. **Note** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST` or `2021-07-09T07:45:30Z`.
     */
    @JvmName("pnksgvfdiaeypgwv")
    public suspend fun createTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.createTime = mapped
    }

    /**
     * @param value The File System ID of Nas. While source_type equals `NAS`, this parameter must be set.
     */
    @JvmName("rofalrcihgljicts")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.fileSystemId = mapped
    }

    /**
     * @param value A list of Snapshot IDs.
     */
    @JvmName("vhlfbvdasmokjxrr")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Snapshot IDs.
     */
    @JvmName("aeiwqdecxayfkhcs")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The ID of ECS instance. The ecs backup client must have been installed on the host. While source_type equals `ECS_FILE`, this parameter must be set.
     */
    @JvmName("sphiqpheggfbikih")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value
     */
    @JvmName("dsmmklcmvnfdsgrv")
    public suspend fun limit(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.limit = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("jhoinnypwvvwoduo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("ablnppmgbrjkqwil")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.query = mapped
    }

    /**
     * @param value Data source type, valid values: `ECS_FILE`, `OSS`, `NAS`.
     */
    @JvmName("kboqitxgnaillywg")
    public suspend fun sourceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sourceType = mapped
    }

    /**
     * @param value The status of snapshot, valid values: `COMPLETE`, `PARTIAL_COMPLETE`.
     */
    @JvmName("rjrgpbcrvmncbjjr")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The ID of Vault.
     */
    @JvmName("etghneoolufegvtx")
    public suspend fun vaultId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultId = mapped
    }

    internal fun build(): GetSnapshotsPlainArgs = GetSnapshotsPlainArgs(
        bucket = bucket,
        completeTime = completeTime,
        completeTimeChecker = completeTimeChecker,
        createTime = createTime,
        fileSystemId = fileSystemId,
        ids = ids,
        instanceId = instanceId,
        limit = limit,
        outputFile = outputFile,
        query = query,
        sourceType = sourceType ?: throw PulumiNullFieldException("sourceType"),
        status = status,
        vaultId = vaultId ?: throw PulumiNullFieldException("vaultId"),
    )
}
