@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.GetVaultsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVaults.
 * @property ids A list of Vault IDs.
 * @property nameRegex A regex string to filter results by Vault name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of Vault. Valid values: `CREATED`, `ERROR`, `UNKNOWN`.
 * @property vaultType VaultType. Valid values: `STANDARD`,`OTS_BACKUP`.
 * - `STANDARD` - used in OSS, NAS and ECS File backup.
 * - `OTS_BACKUP` -  used in OTS backup.
 */
public data class GetVaultsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val vaultType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.GetVaultsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.GetVaultsPlainArgs =
        com.pulumi.alicloud.hbr.inputs.GetVaultsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .vaultType(vaultType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVaultsPlainArgs].
 */
@PulumiTagMarker
public class GetVaultsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var vaultType: String? = null

    /**
     * @param value A list of Vault IDs.
     */
    @JvmName("cqohjgjpgdnevtph")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Vault IDs.
     */
    @JvmName("injmktwyxdgcbsxj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Vault name.
     */
    @JvmName("iuamyollkjgctuvf")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("dhmxixqjojgcpajx")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of Vault. Valid values: `CREATED`, `ERROR`, `UNKNOWN`.
     */
    @JvmName("essbwbjctctbkpsx")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value VaultType. Valid values: `STANDARD`,`OTS_BACKUP`.
     * - `STANDARD` - used in OSS, NAS and ECS File backup.
     * - `OTS_BACKUP` -  used in OTS backup.
     */
    @JvmName("lwjlhrtbdlfpuqhf")
    public suspend fun vaultType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vaultType = mapped
    }

    internal fun build(): GetVaultsPlainArgs = GetVaultsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        status = status,
        vaultType = vaultType,
    )
}
