@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.OtsBackupPlanOtsDetailArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property tableNames The names of the destination tables in the Tablestore instance. **Note:** Required while source_type equals `OTS_TABLE`.
 */
public data class OtsBackupPlanOtsDetailArgs(
    public val tableNames: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.OtsBackupPlanOtsDetailArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.OtsBackupPlanOtsDetailArgs =
        com.pulumi.alicloud.hbr.inputs.OtsBackupPlanOtsDetailArgs.builder()
            .tableNames(tableNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [OtsBackupPlanOtsDetailArgs].
 */
@PulumiTagMarker
public class OtsBackupPlanOtsDetailArgsBuilder internal constructor() {
    private var tableNames: Output<List<String>>? = null

    /**
     * @param value The names of the destination tables in the Tablestore instance. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("ajfgnyeyqytxknof")
    public suspend fun tableNames(`value`: Output<List<String>>) {
        this.tableNames = value
    }

    @JvmName("rblvdhojfqvnaixv")
    public suspend fun tableNames(vararg values: Output<String>) {
        this.tableNames = Output.all(values.asList())
    }

    /**
     * @param values The names of the destination tables in the Tablestore instance. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("lxgubpsqygnvgjad")
    public suspend fun tableNames(values: List<Output<String>>) {
        this.tableNames = Output.all(values)
    }

    /**
     * @param value The names of the destination tables in the Tablestore instance. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("dpkmctdarxtqjoqf")
    public suspend fun tableNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tableNames = mapped
    }

    /**
     * @param values The names of the destination tables in the Tablestore instance. **Note:** Required while source_type equals `OTS_TABLE`.
     */
    @JvmName("eqymtfbifophlewf")
    public suspend fun tableNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tableNames = mapped
    }

    internal fun build(): OtsBackupPlanOtsDetailArgs = OtsBackupPlanOtsDetailArgs(
        tableNames = tableNames,
    )
}
