@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.OtsBackupPlanRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property backupType Backup type. Valid values: `COMPLETE`.
 * @property disabled Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
 * @property retention Backup retention days, the minimum is 1.
 * @property ruleName The name of the backup rule.**Note:** Required while source_type equals `OTS_TABLE`. `rule_name` should be unique for the specific user.
 * @property schedule Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
 * - `startTime` Backup start time, UNIX time seconds.
 */
public data class OtsBackupPlanRuleArgs(
    public val backupType: Output<String>? = null,
    public val disabled: Output<Boolean>? = null,
    public val retention: Output<String>? = null,
    public val ruleName: Output<String>? = null,
    public val schedule: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.OtsBackupPlanRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.OtsBackupPlanRuleArgs =
        com.pulumi.alicloud.hbr.inputs.OtsBackupPlanRuleArgs.builder()
            .backupType(backupType?.applyValue({ args0 -> args0 }))
            .disabled(disabled?.applyValue({ args0 -> args0 }))
            .retention(retention?.applyValue({ args0 -> args0 }))
            .ruleName(ruleName?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OtsBackupPlanRuleArgs].
 */
@PulumiTagMarker
public class OtsBackupPlanRuleArgsBuilder internal constructor() {
    private var backupType: Output<String>? = null

    private var disabled: Output<Boolean>? = null

    private var retention: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var schedule: Output<String>? = null

    /**
     * @param value Backup type. Valid values: `COMPLETE`.
     */
    @JvmName("etpngjisfdiklbtl")
    public suspend fun backupType(`value`: Output<String>) {
        this.backupType = value
    }

    /**
     * @param value Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
     */
    @JvmName("augjyqbkvmcwfsti")
    public suspend fun disabled(`value`: Output<Boolean>) {
        this.disabled = value
    }

    /**
     * @param value Backup retention days, the minimum is 1.
     */
    @JvmName("uvxlmseqfyjdbdlo")
    public suspend fun retention(`value`: Output<String>) {
        this.retention = value
    }

    /**
     * @param value The name of the backup rule.**Note:** Required while source_type equals `OTS_TABLE`. `rule_name` should be unique for the specific user.
     */
    @JvmName("dngdgjtxwjmnuafj")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
     * - `startTime` Backup start time, UNIX time seconds.
     */
    @JvmName("nieshovjmqoaymuf")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value Backup type. Valid values: `COMPLETE`.
     */
    @JvmName("wtgkehefwhrnkylb")
    public suspend fun backupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupType = mapped
    }

    /**
     * @param value Whether to disable the backup task. Valid values: `true`, `false`. Default values: `false`.
     */
    @JvmName("yikqebafuhbfdrgt")
    public suspend fun disabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disabled = mapped
    }

    /**
     * @param value Backup retention days, the minimum is 1.
     */
    @JvmName("vrfehncgenvtxhpf")
    public suspend fun retention(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retention = mapped
    }

    /**
     * @param value The name of the backup rule.**Note:** Required while source_type equals `OTS_TABLE`. `rule_name` should be unique for the specific user.
     */
    @JvmName("vofdmbwtondcafqa")
    public suspend fun ruleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
     * - `startTime` Backup start time, UNIX time seconds.
     */
    @JvmName("tmfcomfrvbdstvgd")
    public suspend fun schedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    internal fun build(): OtsBackupPlanRuleArgs = OtsBackupPlanRuleArgs(
        backupType = backupType,
        disabled = disabled,
        retention = retention,
        ruleName = ruleName,
        schedule = schedule,
    )
}
