@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.PolicyBindingAdvancedOptionsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property udmDetail ECS Backup Advanced options. See `udm_detail` below.
 */
public data class PolicyBindingAdvancedOptionsArgs(
    public val udmDetail: Output<PolicyBindingAdvancedOptionsUdmDetailArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.PolicyBindingAdvancedOptionsArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.PolicyBindingAdvancedOptionsArgs =
        com.pulumi.alicloud.hbr.inputs.PolicyBindingAdvancedOptionsArgs.builder()
            .udmDetail(udmDetail?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [PolicyBindingAdvancedOptionsArgs].
 */
@PulumiTagMarker
public class PolicyBindingAdvancedOptionsArgsBuilder internal constructor() {
    private var udmDetail: Output<PolicyBindingAdvancedOptionsUdmDetailArgs>? = null

    /**
     * @param value ECS Backup Advanced options. See `udm_detail` below.
     */
    @JvmName("hkbhbxktmgdrybgj")
    public suspend fun udmDetail(`value`: Output<PolicyBindingAdvancedOptionsUdmDetailArgs>) {
        this.udmDetail = value
    }

    /**
     * @param value ECS Backup Advanced options. See `udm_detail` below.
     */
    @JvmName("gqmcrwggbsiefsls")
    public suspend fun udmDetail(`value`: PolicyBindingAdvancedOptionsUdmDetailArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.udmDetail = mapped
    }

    /**
     * @param argument ECS Backup Advanced options. See `udm_detail` below.
     */
    @JvmName("flcciqssafohufhg")
    public suspend fun udmDetail(argument: suspend PolicyBindingAdvancedOptionsUdmDetailArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyBindingAdvancedOptionsUdmDetailArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.udmDetail = mapped
    }

    internal fun build(): PolicyBindingAdvancedOptionsArgs = PolicyBindingAdvancedOptionsArgs(
        udmDetail = udmDetail,
    )
}
