@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.PolicyBindingAdvancedOptionsUdmDetailArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property destinationKmsKeyId Custom KMS key ID of encrypted copy.
 * @property diskIdLists The list of backup disks. If it is empty, all disks are backed up.
 * @property excludeDiskIdLists List of cloud disk IDs that are not backed up.
 */
public data class PolicyBindingAdvancedOptionsUdmDetailArgs(
    public val destinationKmsKeyId: Output<String>? = null,
    public val diskIdLists: Output<List<String>>? = null,
    public val excludeDiskIdLists: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.PolicyBindingAdvancedOptionsUdmDetailArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.PolicyBindingAdvancedOptionsUdmDetailArgs =
        com.pulumi.alicloud.hbr.inputs.PolicyBindingAdvancedOptionsUdmDetailArgs.builder()
            .destinationKmsKeyId(destinationKmsKeyId?.applyValue({ args0 -> args0 }))
            .diskIdLists(diskIdLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .excludeDiskIdLists(
                excludeDiskIdLists?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [PolicyBindingAdvancedOptionsUdmDetailArgs].
 */
@PulumiTagMarker
public class PolicyBindingAdvancedOptionsUdmDetailArgsBuilder internal constructor() {
    private var destinationKmsKeyId: Output<String>? = null

    private var diskIdLists: Output<List<String>>? = null

    private var excludeDiskIdLists: Output<List<String>>? = null

    /**
     * @param value Custom KMS key ID of encrypted copy.
     */
    @JvmName("lxgimyabcmstkxfg")
    public suspend fun destinationKmsKeyId(`value`: Output<String>) {
        this.destinationKmsKeyId = value
    }

    /**
     * @param value The list of backup disks. If it is empty, all disks are backed up.
     */
    @JvmName("hxdldusgyvwvwfkj")
    public suspend fun diskIdLists(`value`: Output<List<String>>) {
        this.diskIdLists = value
    }

    @JvmName("ovjqyxllljokxonq")
    public suspend fun diskIdLists(vararg values: Output<String>) {
        this.diskIdLists = Output.all(values.asList())
    }

    /**
     * @param values The list of backup disks. If it is empty, all disks are backed up.
     */
    @JvmName("adryhqssjhsreyfn")
    public suspend fun diskIdLists(values: List<Output<String>>) {
        this.diskIdLists = Output.all(values)
    }

    /**
     * @param value List of cloud disk IDs that are not backed up.
     */
    @JvmName("hiesrmtcwnxuxufi")
    public suspend fun excludeDiskIdLists(`value`: Output<List<String>>) {
        this.excludeDiskIdLists = value
    }

    @JvmName("rtfogaoetlgsxnll")
    public suspend fun excludeDiskIdLists(vararg values: Output<String>) {
        this.excludeDiskIdLists = Output.all(values.asList())
    }

    /**
     * @param values List of cloud disk IDs that are not backed up.
     */
    @JvmName("etktdlnlwbbnmwla")
    public suspend fun excludeDiskIdLists(values: List<Output<String>>) {
        this.excludeDiskIdLists = Output.all(values)
    }

    /**
     * @param value Custom KMS key ID of encrypted copy.
     */
    @JvmName("jvsbuydemjgmfeya")
    public suspend fun destinationKmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationKmsKeyId = mapped
    }

    /**
     * @param value The list of backup disks. If it is empty, all disks are backed up.
     */
    @JvmName("utpdrofvdbteloiv")
    public suspend fun diskIdLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskIdLists = mapped
    }

    /**
     * @param values The list of backup disks. If it is empty, all disks are backed up.
     */
    @JvmName("aheskbechssvxcbm")
    public suspend fun diskIdLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskIdLists = mapped
    }

    /**
     * @param value List of cloud disk IDs that are not backed up.
     */
    @JvmName("lqcxapsnkkefbbik")
    public suspend fun excludeDiskIdLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeDiskIdLists = mapped
    }

    /**
     * @param values List of cloud disk IDs that are not backed up.
     */
    @JvmName("flgylxetxpwdfuwt")
    public suspend fun excludeDiskIdLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludeDiskIdLists = mapped
    }

    internal fun build(): PolicyBindingAdvancedOptionsUdmDetailArgs =
        PolicyBindingAdvancedOptionsUdmDetailArgs(
            destinationKmsKeyId = destinationKmsKeyId,
            diskIdLists = diskIdLists,
            excludeDiskIdLists = excludeDiskIdLists,
        )
}
