@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.PolicyRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property archiveDays This parameter is required only when the value of **RuleType** is **TRANSITION. The minimum value is 30, and the Retention-ArchiveDays needs to be greater than or equal to 60.
 * @property backupType This parameter is required only when the **RuleType** value is **BACKUP. Backup Type.
 * @property keepLatestSnapshots This parameter is required only when **RuleType** is set to **BACKUP**.
 * @property replicationRegionId Only when the **RuleType** value is.
 * @property retention Retention time, in days.
 * @property retentionRules This parameter is required only when the value of **RuleType** is **TRANSITION**. See `retention_rules` below.
 * @property ruleId Rule ID.
 * @property ruleType Rule Type.
 * @property schedule This parameter is required only if you set the **RuleType** parameter to **BACKUP**. This parameter specifies the backup schedule settings. Format: `I|{startTime}|{interval}`. The system runs the first backup job at a point in time that is specified in the {startTime} parameter and the subsequent backup jobs at an interval that is specified in the {interval} parameter. The system does not run a backup job before the specified point in time. Each backup job, except the first one, starts only after the previous backup job is complete. For example, `I|1631685600|P1D` specifies that the system runs the first backup job at 14:00:00 on September 15, 2021 and the subsequent backup jobs once a day.  *   startTime: the time at which the system starts to run a backup job. The time must follow the UNIX time format. Unit: seconds. *   interval: the interval at which the system runs a backup job. The interval must follow the ISO 8601 standard. For example, PT1H specifies an interval of one hour. P1D specifies an interval of one day.
 * @property vaultId Vault ID.
 */
public data class PolicyRuleArgs(
    public val archiveDays: Output<Int>? = null,
    public val backupType: Output<String>? = null,
    public val keepLatestSnapshots: Output<Int>? = null,
    public val replicationRegionId: Output<String>? = null,
    public val retention: Output<Int>? = null,
    public val retentionRules: Output<List<PolicyRuleRetentionRuleArgs>>? = null,
    public val ruleId: Output<String>? = null,
    public val ruleType: Output<String>,
    public val schedule: Output<String>? = null,
    public val vaultId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.PolicyRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.PolicyRuleArgs =
        com.pulumi.alicloud.hbr.inputs.PolicyRuleArgs.builder()
            .archiveDays(archiveDays?.applyValue({ args0 -> args0 }))
            .backupType(backupType?.applyValue({ args0 -> args0 }))
            .keepLatestSnapshots(keepLatestSnapshots?.applyValue({ args0 -> args0 }))
            .replicationRegionId(replicationRegionId?.applyValue({ args0 -> args0 }))
            .retention(retention?.applyValue({ args0 -> args0 }))
            .retentionRules(
                retentionRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ruleId(ruleId?.applyValue({ args0 -> args0 }))
            .ruleType(ruleType.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0 }))
            .vaultId(vaultId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyRuleArgs].
 */
@PulumiTagMarker
public class PolicyRuleArgsBuilder internal constructor() {
    private var archiveDays: Output<Int>? = null

    private var backupType: Output<String>? = null

    private var keepLatestSnapshots: Output<Int>? = null

    private var replicationRegionId: Output<String>? = null

    private var retention: Output<Int>? = null

    private var retentionRules: Output<List<PolicyRuleRetentionRuleArgs>>? = null

    private var ruleId: Output<String>? = null

    private var ruleType: Output<String>? = null

    private var schedule: Output<String>? = null

    private var vaultId: Output<String>? = null

    /**
     * @param value This parameter is required only when the value of **RuleType** is **TRANSITION. The minimum value is 30, and the Retention-ArchiveDays needs to be greater than or equal to 60.
     */
    @JvmName("giltgaytcckofvfu")
    public suspend fun archiveDays(`value`: Output<Int>) {
        this.archiveDays = value
    }

    /**
     * @param value This parameter is required only when the **RuleType** value is **BACKUP. Backup Type.
     */
    @JvmName("bchvguwdaosfkiqf")
    public suspend fun backupType(`value`: Output<String>) {
        this.backupType = value
    }

    /**
     * @param value This parameter is required only when **RuleType** is set to **BACKUP**.
     */
    @JvmName("wbietduhsupvytns")
    public suspend fun keepLatestSnapshots(`value`: Output<Int>) {
        this.keepLatestSnapshots = value
    }

    /**
     * @param value Only when the **RuleType** value is.
     */
    @JvmName("yammielwelheetji")
    public suspend fun replicationRegionId(`value`: Output<String>) {
        this.replicationRegionId = value
    }

    /**
     * @param value Retention time, in days.
     */
    @JvmName("movkpdranufodbkf")
    public suspend fun retention(`value`: Output<Int>) {
        this.retention = value
    }

    /**
     * @param value This parameter is required only when the value of **RuleType** is **TRANSITION**. See `retention_rules` below.
     */
    @JvmName("kapkycvniqegygln")
    public suspend fun retentionRules(`value`: Output<List<PolicyRuleRetentionRuleArgs>>) {
        this.retentionRules = value
    }

    @JvmName("rbptuhhulvxbmwpd")
    public suspend fun retentionRules(vararg values: Output<PolicyRuleRetentionRuleArgs>) {
        this.retentionRules = Output.all(values.asList())
    }

    /**
     * @param values This parameter is required only when the value of **RuleType** is **TRANSITION**. See `retention_rules` below.
     */
    @JvmName("fpspgxvuxfiettyu")
    public suspend fun retentionRules(values: List<Output<PolicyRuleRetentionRuleArgs>>) {
        this.retentionRules = Output.all(values)
    }

    /**
     * @param value Rule ID.
     */
    @JvmName("rsjobfkuypgiamxy")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value Rule Type.
     */
    @JvmName("suncblilvpdrbwxc")
    public suspend fun ruleType(`value`: Output<String>) {
        this.ruleType = value
    }

    /**
     * @param value This parameter is required only if you set the **RuleType** parameter to **BACKUP**. This parameter specifies the backup schedule settings. Format: `I|{startTime}|{interval}`. The system runs the first backup job at a point in time that is specified in the {startTime} parameter and the subsequent backup jobs at an interval that is specified in the {interval} parameter. The system does not run a backup job before the specified point in time. Each backup job, except the first one, starts only after the previous backup job is complete. For example, `I|1631685600|P1D` specifies that the system runs the first backup job at 14:00:00 on September 15, 2021 and the subsequent backup jobs once a day.  *   startTime: the time at which the system starts to run a backup job. The time must follow the UNIX time format. Unit: seconds. *   interval: the interval at which the system runs a backup job. The interval must follow the ISO 8601 standard. For example, PT1H specifies an interval of one hour. P1D specifies an interval of one day.
     */
    @JvmName("mwyhtlxlsmfyqxih")
    public suspend fun schedule(`value`: Output<String>) {
        this.schedule = value
    }

    /**
     * @param value Vault ID.
     */
    @JvmName("pnmpymmqccabgalt")
    public suspend fun vaultId(`value`: Output<String>) {
        this.vaultId = value
    }

    /**
     * @param value This parameter is required only when the value of **RuleType** is **TRANSITION. The minimum value is 30, and the Retention-ArchiveDays needs to be greater than or equal to 60.
     */
    @JvmName("bryhsjmccutydyng")
    public suspend fun archiveDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.archiveDays = mapped
    }

    /**
     * @param value This parameter is required only when the **RuleType** value is **BACKUP. Backup Type.
     */
    @JvmName("eqcrxcuvfcjhmlwt")
    public suspend fun backupType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupType = mapped
    }

    /**
     * @param value This parameter is required only when **RuleType** is set to **BACKUP**.
     */
    @JvmName("dgqxnhjjicqruqka")
    public suspend fun keepLatestSnapshots(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keepLatestSnapshots = mapped
    }

    /**
     * @param value Only when the **RuleType** value is.
     */
    @JvmName("nedergciokilvrfp")
    public suspend fun replicationRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationRegionId = mapped
    }

    /**
     * @param value Retention time, in days.
     */
    @JvmName("yntasilioyesjfhf")
    public suspend fun retention(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retention = mapped
    }

    /**
     * @param value This parameter is required only when the value of **RuleType** is **TRANSITION**. See `retention_rules` below.
     */
    @JvmName("uqwubtsekkanslqj")
    public suspend fun retentionRules(`value`: List<PolicyRuleRetentionRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionRules = mapped
    }

    /**
     * @param argument This parameter is required only when the value of **RuleType** is **TRANSITION**. See `retention_rules` below.
     */
    @JvmName("ejnpyejjhnmloarq")
    public suspend fun retentionRules(argument: List<suspend PolicyRuleRetentionRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PolicyRuleRetentionRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.retentionRules = mapped
    }

    /**
     * @param argument This parameter is required only when the value of **RuleType** is **TRANSITION**. See `retention_rules` below.
     */
    @JvmName("gplmyyrymcxkfssm")
    public suspend fun retentionRules(vararg argument: suspend PolicyRuleRetentionRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PolicyRuleRetentionRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.retentionRules = mapped
    }

    /**
     * @param argument This parameter is required only when the value of **RuleType** is **TRANSITION**. See `retention_rules` below.
     */
    @JvmName("gghndlceuxwoksjj")
    public suspend fun retentionRules(argument: suspend PolicyRuleRetentionRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PolicyRuleRetentionRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.retentionRules = mapped
    }

    /**
     * @param values This parameter is required only when the value of **RuleType** is **TRANSITION**. See `retention_rules` below.
     */
    @JvmName("jgwwceasvuyukoxw")
    public suspend fun retentionRules(vararg values: PolicyRuleRetentionRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.retentionRules = mapped
    }

    /**
     * @param value Rule ID.
     */
    @JvmName("iijdflqawgojarea")
    public suspend fun ruleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    /**
     * @param value Rule Type.
     */
    @JvmName("jotxfturadmvjhex")
    public suspend fun ruleType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value This parameter is required only if you set the **RuleType** parameter to **BACKUP**. This parameter specifies the backup schedule settings. Format: `I|{startTime}|{interval}`. The system runs the first backup job at a point in time that is specified in the {startTime} parameter and the subsequent backup jobs at an interval that is specified in the {interval} parameter. The system does not run a backup job before the specified point in time. Each backup job, except the first one, starts only after the previous backup job is complete. For example, `I|1631685600|P1D` specifies that the system runs the first backup job at 14:00:00 on September 15, 2021 and the subsequent backup jobs once a day.  *   startTime: the time at which the system starts to run a backup job. The time must follow the UNIX time format. Unit: seconds. *   interval: the interval at which the system runs a backup job. The interval must follow the ISO 8601 standard. For example, PT1H specifies an interval of one hour. P1D specifies an interval of one day.
     */
    @JvmName("avbeiknfkdjuyqwa")
    public suspend fun schedule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value Vault ID.
     */
    @JvmName("kygyutydxltyaxre")
    public suspend fun vaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultId = mapped
    }

    internal fun build(): PolicyRuleArgs = PolicyRuleArgs(
        archiveDays = archiveDays,
        backupType = backupType,
        keepLatestSnapshots = keepLatestSnapshots,
        replicationRegionId = replicationRegionId,
        retention = retention,
        retentionRules = retentionRules,
        ruleId = ruleId,
        ruleType = ruleType ?: throw PulumiNullFieldException("ruleType"),
        schedule = schedule,
        vaultId = vaultId,
    )
}
