@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.PolicyRuleRetentionRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property advancedRetentionType Valid values: **annually**, **MONTHLY**, and **WEEKLY**:- **annually**: the first backup of each year. - **MONTHLY**: The first backup of the month. - **WEEKLY**: The first backup of the week.
 * @property retention Retention time, in days.
 */
public data class PolicyRuleRetentionRuleArgs(
    public val advancedRetentionType: Output<String>? = null,
    public val retention: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.PolicyRuleRetentionRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.PolicyRuleRetentionRuleArgs =
        com.pulumi.alicloud.hbr.inputs.PolicyRuleRetentionRuleArgs.builder()
            .advancedRetentionType(advancedRetentionType?.applyValue({ args0 -> args0 }))
            .retention(retention?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicyRuleRetentionRuleArgs].
 */
@PulumiTagMarker
public class PolicyRuleRetentionRuleArgsBuilder internal constructor() {
    private var advancedRetentionType: Output<String>? = null

    private var retention: Output<Int>? = null

    /**
     * @param value Valid values: **annually**, **MONTHLY**, and **WEEKLY**:- **annually**: the first backup of each year. - **MONTHLY**: The first backup of the month. - **WEEKLY**: The first backup of the week.
     */
    @JvmName("abctkhhomyqppcta")
    public suspend fun advancedRetentionType(`value`: Output<String>) {
        this.advancedRetentionType = value
    }

    /**
     * @param value Retention time, in days.
     */
    @JvmName("ivdngsoreglthotg")
    public suspend fun retention(`value`: Output<Int>) {
        this.retention = value
    }

    /**
     * @param value Valid values: **annually**, **MONTHLY**, and **WEEKLY**:- **annually**: the first backup of each year. - **MONTHLY**: The first backup of the month. - **WEEKLY**: The first backup of the week.
     */
    @JvmName("cajbhegsixfryqkn")
    public suspend fun advancedRetentionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advancedRetentionType = mapped
    }

    /**
     * @param value Retention time, in days.
     */
    @JvmName("ytbcttwomdbxwulw")
    public suspend fun retention(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retention = mapped
    }

    internal fun build(): PolicyRuleRetentionRuleArgs = PolicyRuleRetentionRuleArgs(
        advancedRetentionType = advancedRetentionType,
        retention = retention,
    )
}
