@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.RestoreJobOtsDetailArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property overwriteExisting Whether to overwrite the existing table storage recovery task. Valid values: `true`, `false`.
 */
public data class RestoreJobOtsDetailArgs(
    public val overwriteExisting: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.RestoreJobOtsDetailArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.RestoreJobOtsDetailArgs =
        com.pulumi.alicloud.hbr.inputs.RestoreJobOtsDetailArgs.builder()
            .overwriteExisting(overwriteExisting?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RestoreJobOtsDetailArgs].
 */
@PulumiTagMarker
public class RestoreJobOtsDetailArgsBuilder internal constructor() {
    private var overwriteExisting: Output<Boolean>? = null

    /**
     * @param value Whether to overwrite the existing table storage recovery task. Valid values: `true`, `false`.
     */
    @JvmName("esoarghqwdgexefu")
    public suspend fun overwriteExisting(`value`: Output<Boolean>) {
        this.overwriteExisting = value
    }

    /**
     * @param value Whether to overwrite the existing table storage recovery task. Valid values: `true`, `false`.
     */
    @JvmName("reyvylxxdytyorbh")
    public suspend fun overwriteExisting(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.overwriteExisting = mapped
    }

    internal fun build(): RestoreJobOtsDetailArgs = RestoreJobOtsDetailArgs(
        overwriteExisting = overwriteExisting,
    )
}
