@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.inputs

import com.pulumi.alicloud.hbr.inputs.ServerBackupPlanDetailArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property appConsistent Whether to turn on application consistency. The application consistency snapshot backs up memory data and ongoing database transactions at the time of snapshot creation to ensure the consistency of application system data and database transactions. By applying consistent snapshots, there is no data damage or loss, so as to avoid log rollback during database startup and ensure that the application is in a consistent startup state. Valid values: `true`, `false`.
 * @property destinationRegionId Only vaild when DoCopy is true. The destination region ID when replicating to another region. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
 * @property destinationRetention Only vaild when DoCopy is true. The retention days of the destination backup. When not specified, the destination backup will be saved permanently. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
 * @property diskIdLists The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
 * @property doCopy Whether replicate to another region. Valid values: `true`, `false`.
 * @property enableFsFreeze Only the Linux system is valid. Whether to use the Linux FsFreeze mechanism to ensure that the file system is read-only consistent before creating a storage snapshot. The default is True. Valid values: `true`, `false`.
 * @property postScriptPath Only vaild for the linux system when AppConsistent is true. The application thaw script path (e.g. /tmp/postscript.sh). The postscript.sh script must meet the following conditions: in terms of permissions, only the root user as the owner has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
 * @property preScriptPath Only vaild for the linux system when AppConsistent is true. Apply the freeze script path (e.g. /tmp/prescript.sh). prescript.sh scripts must meet the following conditions: in terms of permissions, only root, as the owner, has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
 * @property snapshotGroup Whether to turn on file system consistency. If SnapshotGroup is true, when AppConsistent is true but the relevant conditions are not met or AppConsistent is false, the resulting snapshot will be a file system consistency snapshot. The file system consistency ensures that the file system memory and disk information are synchronized at the time of snapshot creation, and the file system write operation is frozen to make the file system in a consistent state. The file system consistency snapshot can prevent the operating system from performing disk inspection and repair operations such as CHKDSK or fsck after restart. Valid values: `true`, `false`.
 * @property timeoutInSeconds Only the Linux system is valid, and the IO freeze timeout period. The default is 30 seconds.
 */
public data class ServerBackupPlanDetailArgs(
    public val appConsistent: Output<Boolean>,
    public val destinationRegionId: Output<String>? = null,
    public val destinationRetention: Output<Int>? = null,
    public val diskIdLists: Output<List<String>>? = null,
    public val doCopy: Output<Boolean>? = null,
    public val enableFsFreeze: Output<Boolean>? = null,
    public val postScriptPath: Output<String>? = null,
    public val preScriptPath: Output<String>? = null,
    public val snapshotGroup: Output<Boolean>,
    public val timeoutInSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.hbr.inputs.ServerBackupPlanDetailArgs> {
    override fun toJava(): com.pulumi.alicloud.hbr.inputs.ServerBackupPlanDetailArgs =
        com.pulumi.alicloud.hbr.inputs.ServerBackupPlanDetailArgs.builder()
            .appConsistent(appConsistent.applyValue({ args0 -> args0 }))
            .destinationRegionId(destinationRegionId?.applyValue({ args0 -> args0 }))
            .destinationRetention(destinationRetention?.applyValue({ args0 -> args0 }))
            .diskIdLists(diskIdLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .doCopy(doCopy?.applyValue({ args0 -> args0 }))
            .enableFsFreeze(enableFsFreeze?.applyValue({ args0 -> args0 }))
            .postScriptPath(postScriptPath?.applyValue({ args0 -> args0 }))
            .preScriptPath(preScriptPath?.applyValue({ args0 -> args0 }))
            .snapshotGroup(snapshotGroup.applyValue({ args0 -> args0 }))
            .timeoutInSeconds(timeoutInSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerBackupPlanDetailArgs].
 */
@PulumiTagMarker
public class ServerBackupPlanDetailArgsBuilder internal constructor() {
    private var appConsistent: Output<Boolean>? = null

    private var destinationRegionId: Output<String>? = null

    private var destinationRetention: Output<Int>? = null

    private var diskIdLists: Output<List<String>>? = null

    private var doCopy: Output<Boolean>? = null

    private var enableFsFreeze: Output<Boolean>? = null

    private var postScriptPath: Output<String>? = null

    private var preScriptPath: Output<String>? = null

    private var snapshotGroup: Output<Boolean>? = null

    private var timeoutInSeconds: Output<Int>? = null

    /**
     * @param value Whether to turn on application consistency. The application consistency snapshot backs up memory data and ongoing database transactions at the time of snapshot creation to ensure the consistency of application system data and database transactions. By applying consistent snapshots, there is no data damage or loss, so as to avoid log rollback during database startup and ensure that the application is in a consistent startup state. Valid values: `true`, `false`.
     */
    @JvmName("qqiggedyaqaejqya")
    public suspend fun appConsistent(`value`: Output<Boolean>) {
        this.appConsistent = value
    }

    /**
     * @param value Only vaild when DoCopy is true. The destination region ID when replicating to another region. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    @JvmName("xqnhwnsxxcwgjjia")
    public suspend fun destinationRegionId(`value`: Output<String>) {
        this.destinationRegionId = value
    }

    /**
     * @param value Only vaild when DoCopy is true. The retention days of the destination backup. When not specified, the destination backup will be saved permanently. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    @JvmName("mhwoywvavvlaloqy")
    public suspend fun destinationRetention(`value`: Output<Int>) {
        this.destinationRetention = value
    }

    /**
     * @param value The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
     */
    @JvmName("bxqijkuacjxgyyut")
    public suspend fun diskIdLists(`value`: Output<List<String>>) {
        this.diskIdLists = value
    }

    @JvmName("wlxixoyjyqbealwl")
    public suspend fun diskIdLists(vararg values: Output<String>) {
        this.diskIdLists = Output.all(values.asList())
    }

    /**
     * @param values The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
     */
    @JvmName("jjvifcbdnfasxcsr")
    public suspend fun diskIdLists(values: List<Output<String>>) {
        this.diskIdLists = Output.all(values)
    }

    /**
     * @param value Whether replicate to another region. Valid values: `true`, `false`.
     */
    @JvmName("fxhsyfmqnodfhwlg")
    public suspend fun doCopy(`value`: Output<Boolean>) {
        this.doCopy = value
    }

    /**
     * @param value Only the Linux system is valid. Whether to use the Linux FsFreeze mechanism to ensure that the file system is read-only consistent before creating a storage snapshot. The default is True. Valid values: `true`, `false`.
     */
    @JvmName("mqyylfmbgyxuxqqk")
    public suspend fun enableFsFreeze(`value`: Output<Boolean>) {
        this.enableFsFreeze = value
    }

    /**
     * @param value Only vaild for the linux system when AppConsistent is true. The application thaw script path (e.g. /tmp/postscript.sh). The postscript.sh script must meet the following conditions: in terms of permissions, only the root user as the owner has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
     */
    @JvmName("awwfsfunttbfsamh")
    public suspend fun postScriptPath(`value`: Output<String>) {
        this.postScriptPath = value
    }

    /**
     * @param value Only vaild for the linux system when AppConsistent is true. Apply the freeze script path (e.g. /tmp/prescript.sh). prescript.sh scripts must meet the following conditions: in terms of permissions, only root, as the owner, has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
     */
    @JvmName("yejlyqnduuntrpuy")
    public suspend fun preScriptPath(`value`: Output<String>) {
        this.preScriptPath = value
    }

    /**
     * @param value Whether to turn on file system consistency. If SnapshotGroup is true, when AppConsistent is true but the relevant conditions are not met or AppConsistent is false, the resulting snapshot will be a file system consistency snapshot. The file system consistency ensures that the file system memory and disk information are synchronized at the time of snapshot creation, and the file system write operation is frozen to make the file system in a consistent state. The file system consistency snapshot can prevent the operating system from performing disk inspection and repair operations such as CHKDSK or fsck after restart. Valid values: `true`, `false`.
     */
    @JvmName("lcfbesmtfgxdxsjs")
    public suspend fun snapshotGroup(`value`: Output<Boolean>) {
        this.snapshotGroup = value
    }

    /**
     * @param value Only the Linux system is valid, and the IO freeze timeout period. The default is 30 seconds.
     */
    @JvmName("eonkfdtodrsrbdps")
    public suspend fun timeoutInSeconds(`value`: Output<Int>) {
        this.timeoutInSeconds = value
    }

    /**
     * @param value Whether to turn on application consistency. The application consistency snapshot backs up memory data and ongoing database transactions at the time of snapshot creation to ensure the consistency of application system data and database transactions. By applying consistent snapshots, there is no data damage or loss, so as to avoid log rollback during database startup and ensure that the application is in a consistent startup state. Valid values: `true`, `false`.
     */
    @JvmName("djugsnhmjujqfcxg")
    public suspend fun appConsistent(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.appConsistent = mapped
    }

    /**
     * @param value Only vaild when DoCopy is true. The destination region ID when replicating to another region. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    @JvmName("iwpnuakblfnlojwx")
    public suspend fun destinationRegionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationRegionId = mapped
    }

    /**
     * @param value Only vaild when DoCopy is true. The retention days of the destination backup. When not specified, the destination backup will be saved permanently. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
     */
    @JvmName("wpwxolhgcopvouwn")
    public suspend fun destinationRetention(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationRetention = mapped
    }

    /**
     * @param value The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
     */
    @JvmName("ihrugguehfmjsdym")
    public suspend fun diskIdLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskIdLists = mapped
    }

    /**
     * @param values The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
     */
    @JvmName("skdqhetircoxdncx")
    public suspend fun diskIdLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskIdLists = mapped
    }

    /**
     * @param value Whether replicate to another region. Valid values: `true`, `false`.
     */
    @JvmName("watcldhnfhvydpbn")
    public suspend fun doCopy(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.doCopy = mapped
    }

    /**
     * @param value Only the Linux system is valid. Whether to use the Linux FsFreeze mechanism to ensure that the file system is read-only consistent before creating a storage snapshot. The default is True. Valid values: `true`, `false`.
     */
    @JvmName("jaxnekqqxaladkco")
    public suspend fun enableFsFreeze(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableFsFreeze = mapped
    }

    /**
     * @param value Only vaild for the linux system when AppConsistent is true. The application thaw script path (e.g. /tmp/postscript.sh). The postscript.sh script must meet the following conditions: in terms of permissions, only the root user as the owner has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
     */
    @JvmName("tvynpraylsyjmuac")
    public suspend fun postScriptPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.postScriptPath = mapped
    }

    /**
     * @param value Only vaild for the linux system when AppConsistent is true. Apply the freeze script path (e.g. /tmp/prescript.sh). prescript.sh scripts must meet the following conditions: in terms of permissions, only root, as the owner, has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
     */
    @JvmName("qmuxkhrivswmitrg")
    public suspend fun preScriptPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preScriptPath = mapped
    }

    /**
     * @param value Whether to turn on file system consistency. If SnapshotGroup is true, when AppConsistent is true but the relevant conditions are not met or AppConsistent is false, the resulting snapshot will be a file system consistency snapshot. The file system consistency ensures that the file system memory and disk information are synchronized at the time of snapshot creation, and the file system write operation is frozen to make the file system in a consistent state. The file system consistency snapshot can prevent the operating system from performing disk inspection and repair operations such as CHKDSK or fsck after restart. Valid values: `true`, `false`.
     */
    @JvmName("nhoyanqqqrswcjjg")
    public suspend fun snapshotGroup(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.snapshotGroup = mapped
    }

    /**
     * @param value Only the Linux system is valid, and the IO freeze timeout period. The default is 30 seconds.
     */
    @JvmName("xnlckpwjjtehcqrs")
    public suspend fun timeoutInSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutInSeconds = mapped
    }

    internal fun build(): ServerBackupPlanDetailArgs = ServerBackupPlanDetailArgs(
        appConsistent = appConsistent ?: throw PulumiNullFieldException("appConsistent"),
        destinationRegionId = destinationRegionId,
        destinationRetention = destinationRetention,
        diskIdLists = diskIdLists,
        doCopy = doCopy,
        enableFsFreeze = enableFsFreeze,
        postScriptPath = postScriptPath,
        preScriptPath = preScriptPath,
        snapshotGroup = snapshotGroup ?: throw PulumiNullFieldException("snapshotGroup"),
        timeoutInSeconds = timeoutInSeconds,
    )
}
