@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property key The key of the field to filter. Valid values: `PlanId`, `VaultId`, `InstanceId`, `Bucket`, `FileSystemId`, `CompleteTime`.
 * @property operator The operator of the field to filter. Valid values: `EQUAL`, `NOT_EQUAL`, `GREATER_THAN`, `GREATER_THAN_OR_EQUAL`, `LESS_THAN`, `LESS_THAN_OR_EQUAL`, `BETWEEN`, `IN`.
 * @property values Set of values that are accepted for the given field.
 * > **NOTE:** Numeric types such as `CompleteTime` do not support `IN` operations for the time being.
 */
public data class GetBackupJobsFilter(
    public val key: String? = null,
    public val `operator`: String? = null,
    public val values: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetBackupJobsFilter): GetBackupJobsFilter = GetBackupJobsFilter(
            key = javaType.key().map({ args0 -> args0 }).orElse(null),
            `operator` = javaType.`operator`().map({ args0 -> args0 }).orElse(null),
            values = javaType.values().map({ args0 -> args0 }),
        )
    }
}
