@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property actualBytes The actual data volume of the backup task (After deduplication) . Unit byte.
 * @property actualItems The actual number of items in the backup task. (Currently only file backup is available).
 * @property backJobName The name of backup job.
 * @property backupJobId The ID of the backup job.
 * @property backupType Backup type. Valid values: `COMPLETE`(full backup).
 * @property bucket The name of target OSS bucket.
 * @property bytesDone The amount of backup data (Incremental). Unit byte.
 * @property bytesTotal The total amount of data sources. Unit byte.
 * @property completeTime The completion time of backup job. UNIX time seconds.
 * @property createTime The creation time of backup job. UNIX time seconds.
 * @property crossAccountRoleName The role name created in the original account RAM backup by the cross account managed by the current account. It is valid only when `source_type` is `ECS_FILE`, `NAS`, `OSS` or `OTS`.
 * @property crossAccountType The type of the cross account backup. It is valid only when `source_type` is `ECS_FILE`, `NAS`, `OSS` or `OTS`.
 * @property crossAccountUserId The original account ID of the cross account backup managed by the current account. It is valid only when `source_type` is `ECS_FILE`, `NAS`, `OSS` or `OTS`.
 * @property errorMessage Error message.
 * @property exclude Exclude path. String of Json list. Up to 255 characters. e.g. `"[\"/home/work\"]"`
 * @property fileSystemId The ID of destination file system.
 * @property id The ID of the backup job.
 * @property include Include path. String of Json list. Up to 255 characters. e.g. `"[\"/var\"]"`
 * @property instanceId The ID of target ECS instance.
 * @property itemsDone The number of items restore job recovered.
 * @property itemsTotal The total number of items restore job recovered.
 * @property nasCreateTime File system creation time. UNIX time in seconds.
 * @property otsDetails
 * @property paths List of backup path. e.g. `["/home", "/var"]`.
 * @property planId The ID of a backup plan.
 * @property prefix The prefix of Oss bucket files.
 * @property progress Backup progress. The value is 100%*100.
 * @property sourceType The type of data source. Valid Values: `ECS_FILE`, `OSS`, `NAS`, `UDM_DISK`.
 * @property startTime The scheduled backup start time. UNIX time seconds.
 * @property status The status of restore job. Valid values: `COMPLETE` , `PARTIAL_COMPLETE`, `FAILED`.
 * @property updatedTime The update time of backup job. UNIX time seconds.
 * @property vaultId The ID of backup vault.
 */
public data class GetBackupJobsJob(
    public val actualBytes: String,
    public val actualItems: String,
    public val backJobName: String,
    public val backupJobId: String,
    public val backupType: String,
    public val bucket: String,
    public val bytesDone: String,
    public val bytesTotal: String,
    public val completeTime: String,
    public val createTime: String,
    public val crossAccountRoleName: String,
    public val crossAccountType: String,
    public val crossAccountUserId: Int,
    public val errorMessage: String,
    public val exclude: String,
    public val fileSystemId: String,
    public val id: String,
    public val include: String,
    public val instanceId: String,
    public val itemsDone: String,
    public val itemsTotal: String,
    public val nasCreateTime: String,
    public val otsDetails: List<GetBackupJobsJobOtsDetail>,
    public val paths: List<String>,
    public val planId: String,
    public val prefix: String,
    public val progress: String,
    public val sourceType: String,
    public val startTime: String,
    public val status: String,
    public val updatedTime: String,
    public val vaultId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetBackupJobsJob): GetBackupJobsJob = GetBackupJobsJob(
            actualBytes = javaType.actualBytes(),
            actualItems = javaType.actualItems(),
            backJobName = javaType.backJobName(),
            backupJobId = javaType.backupJobId(),
            backupType = javaType.backupType(),
            bucket = javaType.bucket(),
            bytesDone = javaType.bytesDone(),
            bytesTotal = javaType.bytesTotal(),
            completeTime = javaType.completeTime(),
            createTime = javaType.createTime(),
            crossAccountRoleName = javaType.crossAccountRoleName(),
            crossAccountType = javaType.crossAccountType(),
            crossAccountUserId = javaType.crossAccountUserId(),
            errorMessage = javaType.errorMessage(),
            exclude = javaType.exclude(),
            fileSystemId = javaType.fileSystemId(),
            id = javaType.id(),
            include = javaType.include(),
            instanceId = javaType.instanceId(),
            itemsDone = javaType.itemsDone(),
            itemsTotal = javaType.itemsTotal(),
            nasCreateTime = javaType.nasCreateTime(),
            otsDetails = javaType.otsDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetBackupJobsJobOtsDetail.Companion.toKotlin(args0)
                })
            }),
            paths = javaType.paths().map({ args0 -> args0 }),
            planId = javaType.planId(),
            prefix = javaType.prefix(),
            progress = javaType.progress(),
            sourceType = javaType.sourceType(),
            startTime = javaType.startTime(),
            status = javaType.status(),
            updatedTime = javaType.updatedTime(),
            vaultId = javaType.vaultId(),
        )
    }
}
