@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getBackupJobs.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property jobs
 * @property outputFile
 * @property sortDirection
 * @property sourceType
 * @property status
 */
public data class GetBackupJobsResult(
    public val filters: List<GetBackupJobsFilter>? = null,
    public val id: String,
    public val ids: List<String>,
    public val jobs: List<GetBackupJobsJob>,
    public val outputFile: String? = null,
    public val sortDirection: String? = null,
    public val sourceType: String,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetBackupJobsResult): GetBackupJobsResult = GetBackupJobsResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetBackupJobsFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            jobs = javaType.jobs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetBackupJobsJob.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            sortDirection = javaType.sortDirection().map({ args0 -> args0 }).orElse(null),
            sourceType = javaType.sourceType(),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
