@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property archType The system architecture of client, only the ECS File Backup Client is available. Valid values: `AMD64` , `386`.
 * @property backupStatus Client protected status. Valid values: `UNPROTECTED`, `PROTECTED`.
 * @property clientType The type of client. Valid values: `ECS_CLIENT` (ECS File Backup Client).
 * @property clientVersion The version of client.
 * @property createTime The creation time of client. Unix time in seconds.
 * @property dataNetworkType The data plane access point type. Valid Values: `PUBLIC`, `VPC`, `CLASSIC`.
 * @property dataProxySetting The data plane proxy settings. Valid Values: `DISABLE`, `USE_CONTROL_PROXY`, `CUSTOM`.
 * * `USE_CONTROL_PROXY` (Default, the same with control plane)
 * * `CUSTOM` (Custom configuration items for the HTTP protocol).
 * @property ecsBackupClientId The first ID of the resource.
 * @property hostname The hostname of ECS instance.
 * @property id The ID of the Ecs Backup Client.
 * @property instanceId The ID of ECS instance. When the client type is ECS file backup client, it indicates the ID of ECS instance. When the client type is a local file backup client, it is a hardware fingerprint generated based on system information.
 * @property instanceName The name of ECS instance.
 * @property lastHeartBeatTime The last heartbeat time of client. Unix Time Seconds.
 * @property maxClientVersion The latest version of client.
 * @property maxCpuCore The number of CPU cores used by a single backup task, 0 means no restrictions.
 * @property maxWorker The number of concurrent jobs for a single backup task, 0 means no restrictions.
 * @property osType The operating system type of client, only the ECS File Backup Client is available. Valid values: `windows`, `linux`.
 * @property privateIpv4 Intranet IP address of the instance, only available for ECS file backup client.
 * @property proxyHost Custom data plane proxy server host address.
 * @property proxyPassword The password of custom data plane proxy server.
 * @property proxyPort Custom data plane proxy server host port.
 * @property proxyUser The username of custom data plane proxy server.
 * @property status The status of the resource.
 * @property updatedTime The update time of client. Unix Time Seconds.
 * @property useHttps Indicates whether to use the HTTPS protocol. Valid values: `true`, `false`.
 * @property zoneId The ID of Zone.
 */
public data class GetEcsBackupClientsClient(
    public val archType: String,
    public val backupStatus: String,
    public val clientType: String,
    public val clientVersion: String,
    public val createTime: String,
    public val dataNetworkType: String,
    public val dataProxySetting: String,
    public val ecsBackupClientId: String,
    public val hostname: String,
    public val id: String,
    public val instanceId: String,
    public val instanceName: String,
    public val lastHeartBeatTime: String,
    public val maxClientVersion: String,
    public val maxCpuCore: String,
    public val maxWorker: String,
    public val osType: String,
    public val privateIpv4: String,
    public val proxyHost: String,
    public val proxyPassword: String,
    public val proxyPort: String,
    public val proxyUser: String,
    public val status: String,
    public val updatedTime: String,
    public val useHttps: Boolean,
    public val zoneId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetEcsBackupClientsClient): GetEcsBackupClientsClient = GetEcsBackupClientsClient(
            archType = javaType.archType(),
            backupStatus = javaType.backupStatus(),
            clientType = javaType.clientType(),
            clientVersion = javaType.clientVersion(),
            createTime = javaType.createTime(),
            dataNetworkType = javaType.dataNetworkType(),
            dataProxySetting = javaType.dataProxySetting(),
            ecsBackupClientId = javaType.ecsBackupClientId(),
            hostname = javaType.hostname(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            instanceName = javaType.instanceName(),
            lastHeartBeatTime = javaType.lastHeartBeatTime(),
            maxClientVersion = javaType.maxClientVersion(),
            maxCpuCore = javaType.maxCpuCore(),
            maxWorker = javaType.maxWorker(),
            osType = javaType.osType(),
            privateIpv4 = javaType.privateIpv4(),
            proxyHost = javaType.proxyHost(),
            proxyPassword = javaType.proxyPassword(),
            proxyPort = javaType.proxyPort(),
            proxyUser = javaType.proxyUser(),
            status = javaType.status(),
            updatedTime = javaType.updatedTime(),
            useHttps = javaType.useHttps(),
            zoneId = javaType.zoneId(),
        )
    }
}
