@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEcsBackupClients.
 * @property clients
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceIds
 * @property outputFile
 * @property status
 */
public data class GetEcsBackupClientsResult(
    public val clients: List<GetEcsBackupClientsClient>,
    public val id: String,
    public val ids: List<String>,
    public val instanceIds: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetEcsBackupClientsResult): GetEcsBackupClientsResult = GetEcsBackupClientsResult(
            clients = javaType.clients().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetEcsBackupClientsClient.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceIds = javaType.instanceIds().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
