@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property backupType Backup type. Valid values: `COMPLETE`.
 * @property createTime
 * @property createdTime The creation time of the backup plan. UNIX time in seconds.
 * @property detail
 * @property disabled Whether to be suspended. Valid values: `true`, `false`.
 * @property ecsBackupPlanId The ID of ecs backup plan.
 * @property ecsBackupPlanName The name of the backup plan.
 * @property exclude Exclude path. String of Json list. Up to 255 characters. e.g. `"[\"/home/work\"]"`
 * @property id The ID of ecs backup plan.
 * @property include Include path. String of Json list. Up to 255 characters. e.g. `"[\"/var\"]"`
 * @property instanceId The ID of ECS instance.
 * @property options Windows operating system with application consistency using VSS. eg: {`UseVSS`:false}.
 * @property paths Backup path. e.g. `["/home", "/var"]`
 * @property retention Backup retention days, the minimum is 1.
 * @property schedule Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
 * * `startTime` Backup start time, UNIX time seconds.
 * @property sourceType The type of backup source.
 * @property speedLimit Flow control. The format is: {start}|{end}|{bandwidth}. Use `|` to separate multiple flow control configurations, multiple flow control configurations not allowed to have overlapping times.
 * @property updatedTime The update time of the backup plan. UNIX time in seconds.
 * @property vaultId The ID of Backup vault.
 */
public data class GetEcsBackupPlansPlan(
    public val backupType: String,
    public val createTime: String,
    public val createdTime: String,
    public val detail: String,
    public val disabled: Boolean,
    public val ecsBackupPlanId: String,
    public val ecsBackupPlanName: String,
    public val exclude: String,
    public val id: String,
    public val include: String,
    public val instanceId: String,
    public val options: String,
    public val paths: List<String>,
    public val retention: String,
    public val schedule: String,
    public val sourceType: String,
    public val speedLimit: String,
    public val updatedTime: String,
    public val vaultId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetEcsBackupPlansPlan): GetEcsBackupPlansPlan = GetEcsBackupPlansPlan(
            backupType = javaType.backupType(),
            createTime = javaType.createTime(),
            createdTime = javaType.createdTime(),
            detail = javaType.detail(),
            disabled = javaType.disabled(),
            ecsBackupPlanId = javaType.ecsBackupPlanId(),
            ecsBackupPlanName = javaType.ecsBackupPlanName(),
            exclude = javaType.exclude(),
            id = javaType.id(),
            include = javaType.include(),
            instanceId = javaType.instanceId(),
            options = javaType.options(),
            paths = javaType.paths().map({ args0 -> args0 }),
            retention = javaType.retention(),
            schedule = javaType.schedule(),
            sourceType = javaType.sourceType(),
            speedLimit = javaType.speedLimit(),
            updatedTime = javaType.updatedTime(),
            vaultId = javaType.vaultId(),
        )
    }
}
