@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getEcsBackupPlans.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property plans
 * @property vaultId
 */
public data class GetEcsBackupPlansResult(
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val plans: List<GetEcsBackupPlansPlan>,
    public val vaultId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetEcsBackupPlansResult): GetEcsBackupPlansResult = GetEcsBackupPlansResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            plans = javaType.plans().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetEcsBackupPlansPlan.Companion.toKotlin(args0)
                })
            }),
            vaultId = javaType.vaultId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
