@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property alertSetting The alert settings.
 * @property clientId The ID of the backup client.
 * @property clientName The name of the backup client.
 * @property clientType The type of the backup client.
 * @property clientVersion The version number of the backup client.
 * @property clusterId The ID of the SAP HANA instance.
 * @property id The id of the Hana Backup Client. It formats as `<vault_id>:<client_id>`.
 * @property instanceId The ID of the instance.
 * @property instanceName The name of the ECS instance.
 * @property maxVersion The maximum version number of the backup client.
 * @property networkType The network type.
 * @property status The status of the Hana Backup Client. Valid Values: `REGISTERED`, `ACTIVATED`, `DEACTIVATED`, `INSTALLING`, `INSTALL_FAILED`, `NOT_INSTALLED`, `UPGRADING`, `UPGRADE_FAILED`, `UNINSTALLING`, `UNINSTALL_FAILED`, `STOPPED`, `UNKNOWN`.
 * @property statusMessage The status information.
 * @property useHttps Indicates whether data is transmitted over HTTPS.
 * @property vaultId The ID of the backup vault.
 */
public data class GetHanaBackupClientsHanaBackupClient(
    public val alertSetting: String,
    public val clientId: String,
    public val clientName: String,
    public val clientType: String,
    public val clientVersion: String,
    public val clusterId: String,
    public val id: String,
    public val instanceId: String,
    public val instanceName: String,
    public val maxVersion: String,
    public val networkType: String,
    public val status: String,
    public val statusMessage: String,
    public val useHttps: Boolean,
    public val vaultId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetHanaBackupClientsHanaBackupClient): GetHanaBackupClientsHanaBackupClient = GetHanaBackupClientsHanaBackupClient(
            alertSetting = javaType.alertSetting(),
            clientId = javaType.clientId(),
            clientName = javaType.clientName(),
            clientType = javaType.clientType(),
            clientVersion = javaType.clientVersion(),
            clusterId = javaType.clusterId(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            instanceName = javaType.instanceName(),
            maxVersion = javaType.maxVersion(),
            networkType = javaType.networkType(),
            status = javaType.status(),
            statusMessage = javaType.statusMessage(),
            useHttps = javaType.useHttps(),
            vaultId = javaType.vaultId(),
        )
    }
}
