@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getHanaBackupClients.
 * @property clientId The ID of the backup client.
 * @property clusterId The ID of the SAP HANA instance.
 * @property hanaBackupClients A list of Hana Backup Clients. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property status The status of the backup client.
 * @property vaultId The ID of the backup vault.
 */
public data class GetHanaBackupClientsResult(
    public val clientId: String? = null,
    public val clusterId: String? = null,
    public val hanaBackupClients: List<GetHanaBackupClientsHanaBackupClient>,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val status: String? = null,
    public val vaultId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetHanaBackupClientsResult): GetHanaBackupClientsResult = GetHanaBackupClientsResult(
            clientId = javaType.clientId().map({ args0 -> args0 }).orElse(null),
            clusterId = javaType.clusterId().map({ args0 -> args0 }).orElse(null),
            hanaBackupClients = javaType.hanaBackupClients().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetHanaBackupClientsHanaBackupClient.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            vaultId = javaType.vaultId(),
        )
    }
}
