@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property backupPrefix The backup prefix.
 * @property backupType The backup type.
 * @property clusterId The ID of the SAP HANA instance.
 * @property databaseName The name of the database.
 * @property id The ID of the resource.
 * @property pageTotal
 * @property planId The ID of the backup plan.
 * @property planName The name of the backup plan.
 * @property schedule The backup policy.
 * @property status The status of the resource.
 * @property vaultId The ID of the backup vault.
 */
public data class GetHanaBackupPlansPlan(
    public val backupPrefix: String,
    public val backupType: String,
    public val clusterId: String,
    public val databaseName: String,
    public val id: String,
    public val pageTotal: String,
    public val planId: String,
    public val planName: String,
    public val schedule: String,
    public val status: String,
    public val vaultId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetHanaBackupPlansPlan): GetHanaBackupPlansPlan = GetHanaBackupPlansPlan(
            backupPrefix = javaType.backupPrefix(),
            backupType = javaType.backupType(),
            clusterId = javaType.clusterId(),
            databaseName = javaType.databaseName(),
            id = javaType.id(),
            pageTotal = javaType.pageTotal(),
            planId = javaType.planId(),
            planName = javaType.planName(),
            schedule = javaType.schedule(),
            status = javaType.status(),
            vaultId = javaType.vaultId(),
        )
    }
}
