@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getHanaBackupPlans.
 * @property clusterId
 * @property databaseName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property pageNumber
 * @property pageSize
 * @property plans
 * @property vaultId
 */
public data class GetHanaBackupPlansResult(
    public val clusterId: String,
    public val databaseName: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
    public val plans: List<GetHanaBackupPlansPlan>,
    public val vaultId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetHanaBackupPlansResult): GetHanaBackupPlansResult = GetHanaBackupPlansResult(
            clusterId = javaType.clusterId(),
            databaseName = javaType.databaseName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            pageNumber = javaType.pageNumber().map({ args0 -> args0 }).orElse(null),
            pageSize = javaType.pageSize().map({ args0 -> args0 }).orElse(null),
            plans = javaType.plans().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetHanaBackupPlansPlan.Companion.toKotlin(args0)
                })
            }),
            vaultId = javaType.vaultId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
