@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property alertSetting The alert settings. Valid value: `INHERITED`, which indicates that the backup client sends alert notifications in the same way as the backup vault.
 * @property hanaInstanceId The ID of the SAP HANA instance.
 * @property hanaName The name of the SAP HANA instance.
 * @property host The private or internal IP address of the host where the primary node of the SAP HANA instance resides.
 * @property id The ID of the Hana Instance. The value formats as `<vault_id>:<hana_instance_id>`.
 * @property instanceNumber The instance number of the SAP HANA system.
 * @property resourceGroupId The ID of the resource group.
 * @property status The status of the SAP HANA instance.
 * @property statusMessage The status information.
 * @property useSsl Indicates whether the SAP HANA instance is connected over Secure Sockets Layer (SSL).
 * @property userName The username of the SYSTEMDB database.
 * @property validateCertificate Indicates whether the SSL certificate of the SAP HANA instance is verified.
 * @property vaultId The ID of the backup vault.
 */
public data class GetHanaInstancesInstance(
    public val alertSetting: String,
    public val hanaInstanceId: String,
    public val hanaName: String,
    public val host: String,
    public val id: String,
    public val instanceNumber: Int,
    public val resourceGroupId: String,
    public val status: String,
    public val statusMessage: String,
    public val useSsl: Boolean,
    public val userName: String,
    public val validateCertificate: Boolean,
    public val vaultId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetHanaInstancesInstance): GetHanaInstancesInstance = GetHanaInstancesInstance(
            alertSetting = javaType.alertSetting(),
            hanaInstanceId = javaType.hanaInstanceId(),
            hanaName = javaType.hanaName(),
            host = javaType.host(),
            id = javaType.id(),
            instanceNumber = javaType.instanceNumber(),
            resourceGroupId = javaType.resourceGroupId(),
            status = javaType.status(),
            statusMessage = javaType.statusMessage(),
            useSsl = javaType.useSsl(),
            userName = javaType.userName(),
            validateCertificate = javaType.validateCertificate(),
            vaultId = javaType.vaultId(),
        )
    }
}
