@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property backupType Backup type. Valid values: `COMPLETE`.
 * @property createTime File System Creation Time. **Note** The time format of the API adopts the ISO 8601 format, such as `2021-07-09T15:45:30CST`.
 * @property createdTime The creation time of the backup plan. UNIX time in seconds.
 * @property disabled Whether to be suspended. Valid values: `true`, `false`.
 * @property fileSystemId The File System ID of Nas.
 * @property id The ID of Nas backup plan.
 * @property nasBackupPlanId The ID of Nas backup plan.
 * @property nasBackupPlanName The name of the resource.
 * @property options Options field of Nas backup plan.
 * @property paths List of backup path. Up to 65536 Characters. e.g.`["/home", "/var"]`
 * @property retention Backup retention days, the minimum is 1.
 * @property schedule Backup strategy. Optional format: `I|{startTime}|{interval}`. It means to execute a backup task every `{interval}` starting from `{startTime}`. The backup task for the elapsed time will not be compensated. If the last backup task has not completed yet, the next backup task will not be triggered.
 * * `startTime` Backup start time, UNIX time seconds.
 * @property updatedTime The update time of the backup plan. UNIX time in seconds.
 * @property vaultId The ID of backup vault.
 */
public data class GetNasBackupPlansPlan(
    public val backupType: String,
    public val createTime: String,
    public val createdTime: String,
    public val disabled: Boolean,
    public val fileSystemId: String,
    public val id: String,
    public val nasBackupPlanId: String,
    public val nasBackupPlanName: String,
    public val options: String,
    public val paths: List<String>,
    public val retention: String,
    public val schedule: String,
    public val updatedTime: String,
    public val vaultId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetNasBackupPlansPlan): GetNasBackupPlansPlan = GetNasBackupPlansPlan(
            backupType = javaType.backupType(),
            createTime = javaType.createTime(),
            createdTime = javaType.createdTime(),
            disabled = javaType.disabled(),
            fileSystemId = javaType.fileSystemId(),
            id = javaType.id(),
            nasBackupPlanId = javaType.nasBackupPlanId(),
            nasBackupPlanName = javaType.nasBackupPlanName(),
            options = javaType.options(),
            paths = javaType.paths().map({ args0 -> args0 }),
            retention = javaType.retention(),
            schedule = javaType.schedule(),
            updatedTime = javaType.updatedTime(),
            vaultId = javaType.vaultId(),
        )
    }
}
