@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getNasBackupPlans.
 * @property fileSystemId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property plans
 * @property vaultId
 */
public data class GetNasBackupPlansResult(
    public val fileSystemId: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val plans: List<GetNasBackupPlansPlan>,
    public val vaultId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetNasBackupPlansResult): GetNasBackupPlansResult = GetNasBackupPlansResult(
            fileSystemId = javaType.fileSystemId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            plans = javaType.plans().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetNasBackupPlansPlan.Companion.toKotlin(args0)
                })
            }),
            vaultId = javaType.vaultId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
