@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property backupType Backup type. Valid values: `COMPLETE`.
 * @property bucket The name of OSS bucket.
 * @property createdTime The creation time of the backup plan. UNIX time in seconds.
 * @property disabled Whether to be suspended. Valid values: `true`, `false`.
 * @property id The ID of Oss backup plan.
 * @property ossBackupPlanId The ID of Oss backup plan.
 * @property ossBackupPlanName The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
 * @property prefix Backup prefix.
 * @property retention Backup retention days, the minimum is 1.
 * @property schedule Backup strategy. Optional format: I|{startTime}|{interval}. It means to execute a backup task every {interval} starting from {startTime}. The backup task for the elapsed time will not be compensated. If the last backup task is not completed yet, the next backup task will not be triggered.
 * * `startTime` Backup start time, UNIX time seconds.
 * @property updatedTime The update time of the backup plan. UNIX time in seconds.
 * @property vaultId The ID of backup vault.
 */
public data class GetOssBackupPlansPlan(
    public val backupType: String,
    public val bucket: String,
    public val createdTime: String,
    public val disabled: Boolean,
    public val id: String,
    public val ossBackupPlanId: String,
    public val ossBackupPlanName: String,
    public val prefix: String,
    public val retention: String,
    public val schedule: String,
    public val updatedTime: String,
    public val vaultId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetOssBackupPlansPlan): GetOssBackupPlansPlan = GetOssBackupPlansPlan(
            backupType = javaType.backupType(),
            bucket = javaType.bucket(),
            createdTime = javaType.createdTime(),
            disabled = javaType.disabled(),
            id = javaType.id(),
            ossBackupPlanId = javaType.ossBackupPlanId(),
            ossBackupPlanName = javaType.ossBackupPlanName(),
            prefix = javaType.prefix(),
            retention = javaType.retention(),
            schedule = javaType.schedule(),
            updatedTime = javaType.updatedTime(),
            vaultId = javaType.vaultId(),
        )
    }
}
