@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property backupType The Backup type. Valid values: `COMPLETE`.
 * @property createdTime The creation time of the backup plan. UNIX time in seconds.
 * @property disabled Whether to be suspended. Valid values: `true`, `false`.
 * @property id The ID of ots backup plan.
 * @property otsBackupPlanId The ID of ots backup plan.
 * @property otsBackupPlanName The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
 * @property otsDetails
 * @property retention The Backup retention days, the minimum is 1.
 * @property schedule The Backup strategy. Optional format: I|{startTime}|{interval}. It means to execute a backup task every {interval} starting from {startTime}. The backup task for the elapsed time will not be compensated. If the last backup task is not completed yet, the next backup task will not be triggered.
 * * `startTime` Backup start time, UNIX time seconds.
 * @property sourceType The type of the data source.
 * @property updatedTime The update time of the backup plan. UNIX time in seconds.
 * *ots_detail - The details about the Tablestore instance.
 * @property vaultId The ID of backup vault.
 */
public data class GetOtsBackupPlansPlan(
    public val backupType: String,
    public val createdTime: String,
    public val disabled: Boolean,
    public val id: String,
    public val otsBackupPlanId: String,
    public val otsBackupPlanName: String,
    public val otsDetails: List<GetOtsBackupPlansPlanOtsDetail>,
    public val retention: String,
    public val schedule: String,
    public val sourceType: String,
    public val updatedTime: String,
    public val vaultId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetOtsBackupPlansPlan): GetOtsBackupPlansPlan = GetOtsBackupPlansPlan(
            backupType = javaType.backupType(),
            createdTime = javaType.createdTime(),
            disabled = javaType.disabled(),
            id = javaType.id(),
            otsBackupPlanId = javaType.otsBackupPlanId(),
            otsBackupPlanName = javaType.otsBackupPlanName(),
            otsDetails = javaType.otsDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetOtsBackupPlansPlanOtsDetail.Companion.toKotlin(args0)
                })
            }),
            retention = javaType.retention(),
            schedule = javaType.schedule(),
            sourceType = javaType.sourceType(),
            updatedTime = javaType.updatedTime(),
            vaultId = javaType.vaultId(),
        )
    }
}
