@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getOtsBackupPlans.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property planId
 * @property planName
 * @property plans
 * @property vaultId
 */
public data class GetOtsBackupPlansResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val planId: String? = null,
    public val planName: String? = null,
    public val plans: List<GetOtsBackupPlansPlan>,
    public val vaultId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetOtsBackupPlansResult): GetOtsBackupPlansResult = GetOtsBackupPlansResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            planId = javaType.planId().map({ args0 -> args0 }).orElse(null),
            planName = javaType.planName().map({ args0 -> args0 }).orElse(null),
            plans = javaType.plans().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetOtsBackupPlansPlan.Companion.toKotlin(args0)
                })
            }),
            vaultId = javaType.vaultId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
