@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getOtsSnapshots.
 * @property endTime
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property outputFile
 * @property snapshots
 * @property startTime
 */
public data class GetOtsSnapshotsResult(
    public val endTime: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val outputFile: String? = null,
    public val snapshots: List<GetOtsSnapshotsSnapshot>,
    public val startTime: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetOtsSnapshotsResult): GetOtsSnapshotsResult = GetOtsSnapshotsResult(
            endTime = javaType.endTime().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            snapshots = javaType.snapshots().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetOtsSnapshotsSnapshot.Companion.toKotlin(args0)
                })
            }),
            startTime = javaType.startTime().map({ args0 -> args0 }).orElse(null),
        )
    }
}
