@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property actualBytes The actual amount of backup snapshots after duplicates are removed. Unit: bytes.
 * @property backupType The backup type. Valid value: `COMPLETE`, which indicates full backup.
 * @property bytesTotal The total amount of data. Unit: bytes.
 * @property completeTime The time when the backup snapshot was completed. This value is a UNIX timestamp. Unit: seconds.
 * @property createTime The time when the Table store instance was created. This value is a UNIX timestamp. Unit: seconds.
 * @property createdTime The time when the backup snapshot was created. This value is a UNIX timestamp. Unit: seconds.
 * @property id The ID of the backup snapshot.
 * @property instanceName The name of the Table store instance.
 * @property jobId The ID of the backup job.
 * @property parentSnapshotHash The hash value of the parent backup snapshot.
 * @property rangeEnd The time when the backup job ended. This value is a UNIX timestamp. Unit: milliseconds.
 * @property rangeStart The time when the backup job started. This value is a UNIX timestamp. Unit: milliseconds.
 * @property retention The retention period of the backup snapshot.
 * @property snapshotHash The hash value of the backup snapshot.
 * @property snapshotId The ID of the backup snapshot.
 * @property sourceType The type of the data source. Valid values: `ECS_FILE`,`PARTIAL_COMPLETE`,`FAILED`
 * @property startTime The start time of the backup snapshot. This value is a UNIX timestamp. Unit: seconds.
 * @property status The status of the backup job. Valid values: `COMPLETE`,`PARTIAL_COMPLETE`,`FAILED`.
 * @property tableName The name of the table in the Table store instance.
 * @property updatedTime The time when the backup snapshot was updated. This value is a UNIX timestamp. Unit: seconds.
 * @property vaultId The ID of the backup vault that stores the backup snapshot.
 */
public data class GetOtsSnapshotsSnapshot(
    public val actualBytes: String,
    public val backupType: String,
    public val bytesTotal: String,
    public val completeTime: String,
    public val createTime: String,
    public val createdTime: String,
    public val id: String,
    public val instanceName: String,
    public val jobId: String,
    public val parentSnapshotHash: String,
    public val rangeEnd: String,
    public val rangeStart: String,
    public val retention: String,
    public val snapshotHash: String,
    public val snapshotId: String,
    public val sourceType: String,
    public val startTime: String,
    public val status: String,
    public val tableName: String,
    public val updatedTime: String,
    public val vaultId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetOtsSnapshotsSnapshot): GetOtsSnapshotsSnapshot = GetOtsSnapshotsSnapshot(
            actualBytes = javaType.actualBytes(),
            backupType = javaType.backupType(),
            bytesTotal = javaType.bytesTotal(),
            completeTime = javaType.completeTime(),
            createTime = javaType.createTime(),
            createdTime = javaType.createdTime(),
            id = javaType.id(),
            instanceName = javaType.instanceName(),
            jobId = javaType.jobId(),
            parentSnapshotHash = javaType.parentSnapshotHash(),
            rangeEnd = javaType.rangeEnd(),
            rangeStart = javaType.rangeStart(),
            retention = javaType.retention(),
            snapshotHash = javaType.snapshotHash(),
            snapshotId = javaType.snapshotId(),
            sourceType = javaType.sourceType(),
            startTime = javaType.startTime(),
            status = javaType.status(),
            tableName = javaType.tableName(),
            updatedTime = javaType.updatedTime(),
            vaultId = javaType.vaultId(),
        )
    }
}
