@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getReplicationVaultRegions.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property outputFile
 * @property regions
 */
public data class GetReplicationVaultRegionsResult(
    public val id: String,
    public val outputFile: String? = null,
    public val regions: List<GetReplicationVaultRegionsRegion>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetReplicationVaultRegionsResult): GetReplicationVaultRegionsResult = GetReplicationVaultRegionsResult(
            id = javaType.id(),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            regions = javaType.regions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetReplicationVaultRegionsRegion.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
