@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property actualBytes The actual size of Snapshot.
 * @property actualItems The actual number of files.
 * @property bytesDone The size of restore job recovered.
 * @property bytesTotal The total size of restore job recovered.
 * @property completeTime The completion time of restore Job.
 * @property createTime The creation time of restore job.
 * @property errorFile
 * @property errorMessage The error message of recovery task execution.
 * @property expireTime The expiration time of restore job. Unix Time in seconds.
 * @property id The ID of the restore job.
 * @property itemsDone The number of items restore job recovered.
 * @property itemsTotal The total number of items restore job recovered.
 * @property options Recovery Options.
 * @property parentId
 * @property progress The recovery progress.
 * @property restoreJobId The ID of restore job.
 * @property restoreType The type of recovery destination. Valid Values: `ECS_FILE`, `OSS`, `NAS`.
 * @property snapshotHash The hashcode of Snapshot.
 * @property snapshotId The ID of Snapshot.
 * @property sourceType The list of data source types. Valid values: `ECS_FILE`, `NAS`, `OSS`, `OTS_TABLE`,`UDM_ECS_ROLLBACK`.
 * @property startTime The start time of restore job. Unix Time in Seconds.
 * @property status The status of restore job.
 * @property targetBucket The name of target ofo OSS bucket.
 * @property targetClientId
 * @property targetCreateTime The creation time of destination file system.
 * @property targetDataSourceId
 * @property targetFileSystemId The ID of destination file system.
 * @property targetInstanceId The ID of target ECS instance.
 * @property targetPath The target file path of ECS instance.
 * @property targetPrefix The file prefix of target OSS object.
 * @property updatedTime The update Time of restore job. Unix Time in Seconds.
 * @property vaultId The ID of backup vault.
 */
public data class GetRestoreJobsJob(
    public val actualBytes: String,
    public val actualItems: String,
    public val bytesDone: String,
    public val bytesTotal: String,
    public val completeTime: String,
    public val createTime: String,
    public val errorFile: String,
    public val errorMessage: String,
    public val expireTime: String,
    public val id: String,
    public val itemsDone: String,
    public val itemsTotal: String,
    public val options: String,
    public val parentId: String,
    public val progress: Int,
    public val restoreJobId: String,
    public val restoreType: String,
    public val snapshotHash: String,
    public val snapshotId: String,
    public val sourceType: String,
    public val startTime: String,
    public val status: String,
    public val targetBucket: String,
    public val targetClientId: String,
    public val targetCreateTime: String,
    public val targetDataSourceId: String,
    public val targetFileSystemId: String,
    public val targetInstanceId: String,
    public val targetPath: String,
    public val targetPrefix: String,
    public val updatedTime: String,
    public val vaultId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetRestoreJobsJob): GetRestoreJobsJob = GetRestoreJobsJob(
            actualBytes = javaType.actualBytes(),
            actualItems = javaType.actualItems(),
            bytesDone = javaType.bytesDone(),
            bytesTotal = javaType.bytesTotal(),
            completeTime = javaType.completeTime(),
            createTime = javaType.createTime(),
            errorFile = javaType.errorFile(),
            errorMessage = javaType.errorMessage(),
            expireTime = javaType.expireTime(),
            id = javaType.id(),
            itemsDone = javaType.itemsDone(),
            itemsTotal = javaType.itemsTotal(),
            options = javaType.options(),
            parentId = javaType.parentId(),
            progress = javaType.progress(),
            restoreJobId = javaType.restoreJobId(),
            restoreType = javaType.restoreType(),
            snapshotHash = javaType.snapshotHash(),
            snapshotId = javaType.snapshotId(),
            sourceType = javaType.sourceType(),
            startTime = javaType.startTime(),
            status = javaType.status(),
            targetBucket = javaType.targetBucket(),
            targetClientId = javaType.targetClientId(),
            targetCreateTime = javaType.targetCreateTime(),
            targetDataSourceId = javaType.targetDataSourceId(),
            targetFileSystemId = javaType.targetFileSystemId(),
            targetInstanceId = javaType.targetInstanceId(),
            targetPath = javaType.targetPath(),
            targetPrefix = javaType.targetPrefix(),
            updatedTime = javaType.updatedTime(),
            vaultId = javaType.vaultId(),
        )
    }
}
