@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRestoreJobs.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property jobs
 * @property outputFile
 * @property restoreIds
 * @property restoreType
 * @property sourceTypes
 * @property status
 * @property targetBuckets
 * @property targetFileSystemIds
 * @property targetInstanceIds
 * @property vaultIds
 */
public data class GetRestoreJobsResult(
    public val id: String,
    public val ids: List<String>,
    public val jobs: List<GetRestoreJobsJob>,
    public val outputFile: String? = null,
    public val restoreIds: List<String>? = null,
    public val restoreType: String,
    public val sourceTypes: List<String>? = null,
    public val status: String? = null,
    public val targetBuckets: List<String>? = null,
    public val targetFileSystemIds: List<String>? = null,
    public val targetInstanceIds: List<String>? = null,
    public val vaultIds: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetRestoreJobsResult): GetRestoreJobsResult = GetRestoreJobsResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            jobs = javaType.jobs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetRestoreJobsJob.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            restoreIds = javaType.restoreIds().map({ args0 -> args0 }),
            restoreType = javaType.restoreType(),
            sourceTypes = javaType.sourceTypes().map({ args0 -> args0 }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            targetBuckets = javaType.targetBuckets().map({ args0 -> args0 }),
            targetFileSystemIds = javaType.targetFileSystemIds().map({ args0 -> args0 }),
            targetInstanceIds = javaType.targetInstanceIds().map({ args0 -> args0 }),
            vaultIds = javaType.vaultIds().map({ args0 -> args0 }),
        )
    }
}
