@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property createTime The creation time of backup plan.
 * @property details ECS server backup plan details.
 * @property disabled Whether to disable the backup task. Valid values: `true`, `false`.
 * @property ecsServerBackupPlanId The ID of the server backup plan.
 * @property ecsServerBackupPlanName The name of the backup plan. 1~64 characters, the backup plan name of each data source type in a single warehouse required to be unique.
 * @property id The ID of the server backup plan.
 * @property instanceId The ID of ECS Instance.
 * @property retention Backup retention days, the minimum is 1.
 * @property schedule Backup strategy.
 */
public data class GetServerBackupPlansPlan(
    public val createTime: String,
    public val details: List<GetServerBackupPlansPlanDetail>,
    public val disabled: Boolean,
    public val ecsServerBackupPlanId: String,
    public val ecsServerBackupPlanName: String,
    public val id: String,
    public val instanceId: String,
    public val retention: String,
    public val schedule: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetServerBackupPlansPlan): GetServerBackupPlansPlan = GetServerBackupPlansPlan(
            createTime = javaType.createTime(),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.hbr.kotlin.outputs.GetServerBackupPlansPlanDetail.Companion.toKotlin(args0)
                })
            }),
            disabled = javaType.disabled(),
            ecsServerBackupPlanId = javaType.ecsServerBackupPlanId(),
            ecsServerBackupPlanName = javaType.ecsServerBackupPlanName(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            retention = javaType.retention(),
            schedule = javaType.schedule(),
        )
    }
}
