@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.hbr.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property appConsistent Whether to turn on application consistency. The application consistency snapshot backs up memory data and ongoing database transactions at the time of snapshot creation to ensure the consistency of application system data and database transactions. By applying consistent snapshots, there is no data damage or loss, so as to avoid log rollback during database startup and ensure that the application is in a consistent startup state. Valid values: `true`, `false`.
 * @property destinationRegionId Only vaild when DoCopy is true. The destination region ID when replicating to another region. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
 * @property destinationRetention Only vaild when DoCopy is true. The retention days of the destination backup. When not specified, the destination backup will be saved permanently. **Note:** Once you set a value of this property, you cannot set it to an empty string anymore.
 * @property diskIdLists The list of cloud disks to be backed up in the ECS instance. When not specified, a snapshot is executed for all the disks on the ECS instance.
 * @property doCopy Whether replicate to another region. Valid values: `true`, `false`.
 * @property enableFsFreeze Only the Linux system is valid. Whether to use the Linux FsFreeze mechanism to ensure that the file system is read-only consistent before creating a storage snapshot. The default is True. Valid values: `true`, `false`.
 * @property postScriptPath Only vaild for the linux system when AppConsistent is true. The application thaw script path (e.g. /tmp/postscript.sh). The postscript.sh script must meet the following conditions: in terms of permissions, only the root user as the owner has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
 * @property preScriptPath Only vaild for the linux system when AppConsistent is true. Apply the freeze script path (e.g. /tmp/prescript.sh). prescript.sh scripts must meet the following conditions: in terms of permissions, only root, as the owner, has read, write, and execute permissions, that is, 700 permissions. In terms of content, the script content needs to be customized according to the application itself. This indicates that this parameter must be set when creating an application consistency snapshot for a Linux instance. If the script is set incorrectly (for example, permissions, save path, or file name are set incorrectly), the resulting snapshot is a file system consistency snapshot.
 * @property snapshotGroup Whether to turn on file system consistency. If SnapshotGroup is true, when AppConsistent is true but the relevant conditions are not met or AppConsistent is false, the resulting snapshot will be a file system consistency snapshot. The file system consistency ensures that the file system memory and disk information are synchronized at the time of snapshot creation, and the file system write operation is frozen to make the file system in a consistent state. The file system consistency snapshot can prevent the operating system from performing disk inspection and repair operations such as CHKDSK or fsck after restart. Valid values: `true`, `false`.
 * @property timeoutInSeconds Only the Linux system is valid, and the IO freeze timeout period. The default is 30 seconds.
 */
public data class GetServerBackupPlansPlanDetail(
    public val appConsistent: Boolean,
    public val destinationRegionId: String,
    public val destinationRetention: Int,
    public val diskIdLists: List<String>,
    public val doCopy: Boolean,
    public val enableFsFreeze: Boolean,
    public val postScriptPath: String,
    public val preScriptPath: String,
    public val snapshotGroup: Boolean,
    public val timeoutInSeconds: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.hbr.outputs.GetServerBackupPlansPlanDetail): GetServerBackupPlansPlanDetail = GetServerBackupPlansPlanDetail(
            appConsistent = javaType.appConsistent(),
            destinationRegionId = javaType.destinationRegionId(),
            destinationRetention = javaType.destinationRetention(),
            diskIdLists = javaType.diskIdLists().map({ args0 -> args0 }),
            doCopy = javaType.doCopy(),
            enableFsFreeze = javaType.enableFsFreeze(),
            postScriptPath = javaType.postScriptPath(),
            preScriptPath = javaType.preScriptPath(),
            snapshotGroup = javaType.snapshotGroup(),
            timeoutInSeconds = javaType.timeoutInSeconds(),
        )
    }
}
